<?php

namespace App\Models\Site\Student\Attendance;

use App\Models\SiteGlobalModel;
use App\Models\Student\StudentHistory;
use Illuminate\Database\Eloquent\Model;

class StudentLeaveDetail extends SiteGlobalModel
{
    protected $table = 'site_student_attendance_leave_details';
    public $timestamps = true;

    protected $casts = [
        'status' => 'integer'
    ];

    const STUDENT_HISTORY_ID = 'student_history_id';
    const STATUS = 'status';


    protected $fillable = [
        self::STUDENT_HISTORY_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::STUDENT_HISTORY_ID,
        self::STATUS,
    ];


    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class, 'student_history_id');
    }


    public function scopeLeaveToday($query, $date)
    {
        return $query->where('leave_date', $date);
    }


}
