<?php

namespace App\Models\Site\StudentAdmission;

use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicOccupation;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Country\Country;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Gender\Gender;
use App\Models\Relation\Relation;
use App\Models\Religion\Religion;
use App\Models\SiteGlobalModel;
use App\Models\Thana\Thana;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteStudentAdmissionApplication extends SiteGlobalModel
{
    public $timestamps = true;
    protected $appends = array('full_name');


    protected $casts = [
        'approve_as_student' => 'integer',
    ];


    protected $table = 'site_student_admission_applications';


    const Academic_group_id = 'academic_group_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_year_id = 'academic_year_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_class_group_id = 'academic_class_group_id';
//    const Academic_section_id = 'academic_section_id';
    const Academic_session_id = 'academic_session_id';
//    const Academic_student_category_id = 'academic_student_category_id';
    const Academic_student_type_id = 'academic_student_type_id';
//    const Academic_student_admission_type_id = 'academic_student_admission_type_id';

    const First_name = 'first_name';
    const Last_name = 'last_name';
    const Father_name = 'father_name';
    const Mother_name = 'mother_name';
    const Student_roll_number = 'student_roll_number';


    const Site_student_admission_declare_id = 'site_student_admission_declare_id';
    const Transaction_number = 'transaction_number';
    const Admission_form_serial_no = 'admission_form_serial_no';
    const Admission_form_no = 'admission_form_no';

    const Father_name_native_language = 'father_name_native_language';
    const Mother_name_native_language = 'mother_name_native_language';
    const Academic_board_id = 'academic_board_id';
    const Board_roll_number = 'board_roll_number';
    const Father_nid = 'father_nid';
    const Mother_nid = 'mother_nid';

    const Academic_subject_ids = 'academic_subject_ids';
    const Optional_subject_ids = 'optional_subject_ids';
    const Selective_markingless_subject_ids = 'selective_markingless_subject_ids';
    const Compulsory_subject_ids = 'compulsory_subject_ids';
    const Religion_subject_id = 'religion_subject_id';

    const Board_registration_number = 'board_registration_number';
//    const Student_roll_number = 'student_roll_number';
    const Registration_no = 'registration_no';
//    const Academic_residence_id = 'academic_residence_id';
//    const Academic_transport_id = 'academic_transport_id';

    const Academic_quata_id = 'academic_quata_id';

    const Previous_academic_class_id = 'previous_academic_class_id';
    const Previous_roll_no = 'previous_roll_no';
    const Previous_gpa = 'previous_gpa';
    const Previous_exam_mark = 'previous_exam_mark';
    const Previous_institute_name = 'previous_institute_name';
    const Previous_institute_location = 'previous_institute_location';
    const Tc_number = 'tc_number';
    const Tc_date = 'tc_date';

    const Email = 'email';
    const Name_native_language = 'name_native_language';
    const Student_contact_number = 'student_contact_number';
    const Blood_group_id = 'blood_group_id';
    const Mother_occupation_id = 'mother_occupation_id';
    const Mother_yearly_income = 'mother_yearly_income';
    const Mother_contact_number = 'mother_contact_number';
    const Mother_email = 'mother_email';
    const Father_occupation_id = 'father_occupation_id';
    const Father_yearly_income = 'father_yearly_income';
    const Father_contact_number = 'father_contact_number';
    const Father_email = 'father_email';

    const Present_address_care_of = 'present_address_care_of';
    const Present_country_id = 'present_country_id';
    const Present_division_id = 'present_division_id';
    const Present_district_id = 'present_district_id';
    const Present_thana_id = 'present_thana_id';
    const Present_address = 'present_address';
    const Present_post_code = 'present_post_code';
    const Present_postoffice_id = 'present_postoffice_id';



    const Permanent_address_care_of = 'permanent_address_care_of';
    const Permanent_country_id = 'permanent_country_id';
    const Permanent_division_id = 'permanent_division_id';
    const Permanent_district_id = 'permanent_district_id';
    const Permanent_thana_id = 'permanent_thana_id';
    const Permanent_address = 'permanent_address';
    const Permanent_post_code = 'permanent_post_code';
    const Permanent_postoffice_id = 'permanent_postoffice_id';


//    const Ex_academic_shift_id = 'ex_academic_shift_id';
//    const Ex_academic_year_id = 'ex_academic_year_id';
//    const Ex_academic_department_id = 'ex_academic_department_id';
//    const Ex_academic_class_id = 'ex_academic_class_id';
//    const Ex_academic_class_group_id = 'ex_academic_class_group_id';
//    const Ex_academic_section_id = 'ex_academic_section_id';
//    const Ex_academic_session_id = 'ex_academic_session_id';
//    const Id_card_code = 'id_card_code';
//    const Ex_roll_number = 'ex_roll_number';


    const Local_guardian_name = 'local_guardian_name';
    const Local_gurdian_mobile = 'local_gurdian_mobile';
    const Local_gurdian_address = 'local_gurdian_address';
    const Local_gurdian_email = 'local_gurdian_email';


    const Gender_id = 'gender_id';
    const Religion_id = 'religion_id';
    const Guardian_student_relation_id = 'guardian_student_relation_id';
    const Emergency_contact = 'emergency_contact';
    const Nid_number = 'nid_number';
    const Passport_no = 'passport_no';
    const Birth_certificate_no = 'birth_certificate_no';
    const Date_of_birth = 'date_of_birth';
    const Unique_code = 'unique_code';
    const Student_image = 'student_image';
    const Local_guardian_image = 'local_guardian_image';

    const Approve_as_student = 'approve_as_student';
    const Site_base_student_registration_declare_id = 'site_base_student_registration_declare_id';
    const Site_id = 'site_id';
    const Client_ip = 'client_ip';
    const APPROVED_AT = 'approved_at';
    const APPROVED_BY = 'approved_by';
    const Status = 'status';

    const Transaction_amount = 'transaction_amount';
    const Transaction_date = 'transaction_date';

    const Menual_form_number = 'menual_form_number';
    const Site_can_approve_student = 'site_can_approve_student';


    protected $fillable = [
        self::Academic_group_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_year_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
//        self::Academic_section_id,
        self::Academic_session_id,
        self::Transaction_number,
        self::Admission_form_serial_no,
        self::Admission_form_no,
        self::Academic_board_id,

        self::Transaction_amount,
        self::Transaction_date,
//        self::Academic_student_category_id,
        self::Academic_student_type_id,
//        self::Academic_student_admission_type_id,


        self::First_name,
        self::Last_name,
        self::Father_name,
        self::Mother_name,
        self::Student_roll_number,

        self::Site_student_admission_declare_id,
        self::Father_name_native_language,
        self::Mother_name_native_language,
        self::Board_roll_number,
        self::Father_nid,
        self::Mother_nid,

        self::Academic_subject_ids,
        self::Optional_subject_ids,
        self::Selective_markingless_subject_ids,
        self::Compulsory_subject_ids,
        self::Religion_subject_id,

        self::Board_registration_number,
//        self::Student_roll_number,
        self::Registration_no,
//        self::Academic_residence_id,
//        self::Academic_transport_id,

        self::Academic_quata_id,
        self::Previous_academic_class_id,
        self::Previous_roll_no,
        self::Previous_gpa,
        self::Previous_exam_mark,
        self::Previous_institute_name,
        self::Previous_institute_location,
        self::Tc_number,
        self::Tc_date,

        self::Email,
        self::Name_native_language,
        self::Student_contact_number,
        self::Blood_group_id,
        self::Mother_occupation_id,
        self::Mother_yearly_income,
        self::Mother_contact_number,
        self::Mother_email,
        self::Father_occupation_id,
        self::Father_yearly_income,
        self::Father_contact_number,
        self::Father_email,

        self::Present_address_care_of,
        self::Present_country_id,
        self::Present_division_id,
        self::Present_district_id,
        self::Present_thana_id,
        self::Present_address,
        self::Present_post_code,
        self::Present_postoffice_id,


        self::Permanent_address_care_of,
        self::Permanent_country_id,
        self::Permanent_division_id,
        self::Permanent_district_id,
        self::Permanent_thana_id,
        self::Permanent_address,
        self::Permanent_post_code,
        self::Permanent_postoffice_id,

//        self::Ex_academic_shift_id,
//        self::Ex_academic_year_id,
//        self::Ex_academic_department_id,
//        self::Ex_academic_class_id,
//        self::Ex_academic_class_group_id,
//        self::Ex_academic_section_id,
//        self::Ex_academic_session_id,
//        self::Id_card_code,
//        self::Ex_roll_number,

        self::Local_guardian_name,
        self::Local_gurdian_mobile,
        self::Local_gurdian_address,
        self::Local_gurdian_email,
        self::Gender_id,
        self::Religion_id,
        self::Guardian_student_relation_id,
        self::Emergency_contact,
        self::Nid_number,
        self::Passport_no,
        self::Birth_certificate_no,
        self::Date_of_birth,
        self::Unique_code,
        self::Student_image,
        self::Local_guardian_image,

        self::Approve_as_student,
        self::Site_base_student_registration_declare_id,
        self::Site_id,
        self::Client_ip,
        self::APPROVED_AT,
        self::APPROVED_BY,
        self::Status,
        self::Site_can_approve_student,
        self::Menual_form_number,

    ];

    public $ownFields = [
        self::Academic_group_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_year_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
//        self::Academic_section_id,
        self::Academic_session_id,
        self::Transaction_number,
        self::Admission_form_serial_no,
        self::Admission_form_no,
        self::Academic_board_id,
//        self::Academic_student_category_id,
        self::Academic_student_type_id,
//        self::Academic_student_admission_type_id,

        self::Transaction_amount,
        self::Transaction_date,

        self::First_name,
        self::Last_name,
        self::Father_name,
        self::Mother_name,
        self::Student_roll_number,

        self::Site_student_admission_declare_id,
        self::Father_name_native_language,
        self::Mother_name_native_language,
        self::Board_roll_number,
        self::Father_nid,
        self::Mother_nid,

        self::Academic_subject_ids,
        self::Optional_subject_ids,
        self::Selective_markingless_subject_ids,
        self::Compulsory_subject_ids,
        self::Religion_subject_id,

        self::Board_registration_number,
//        self::Student_roll_number,
        self::Registration_no,
//        self::Academic_residence_id,
//        self::Academic_transport_id,

        self::Academic_quata_id,
        self::Previous_academic_class_id,
        self::Previous_roll_no,
        self::Previous_gpa,
        self::Previous_exam_mark,
        self::Previous_institute_name,
        self::Previous_institute_location,
        self::Tc_number,
        self::Tc_date,

        self::Email,
        self::Name_native_language,
        self::Student_contact_number,
        self::Blood_group_id,
        self::Mother_occupation_id,
        self::Mother_yearly_income,
        self::Mother_contact_number,
        self::Mother_email,
        self::Father_occupation_id,
        self::Father_yearly_income,
        self::Father_contact_number,
        self::Father_email,

        self::Present_address_care_of,
        self::Present_country_id,
        self::Present_division_id,
        self::Present_district_id,
        self::Present_thana_id,
        self::Present_address,
        self::Present_post_code,
        self::Present_postoffice_id,


        self::Permanent_address_care_of,
        self::Permanent_country_id,
        self::Permanent_division_id,
        self::Permanent_district_id,
        self::Permanent_thana_id,
        self::Permanent_address,
        self::Permanent_post_code,
        self::Permanent_postoffice_id,

//        self::Ex_academic_shift_id,
//        self::Ex_academic_year_id,
//        self::Ex_academic_department_id,
//        self::Ex_academic_class_id,
//        self::Ex_academic_class_group_id,
//        self::Ex_academic_section_id,
//        self::Ex_academic_session_id,
//        self::Id_card_code,
//        self::Ex_roll_number,

        self::Local_guardian_name,
        self::Local_gurdian_mobile,
        self::Local_gurdian_address,
        self::Local_gurdian_email,
        self::Gender_id,
        self::Religion_id,
        self::Guardian_student_relation_id,
        self::Emergency_contact,
        self::Nid_number,
        self::Passport_no,
        self::Birth_certificate_no,
        self::Date_of_birth,
        self::Unique_code,
        self::Student_image,
        self::Local_guardian_image,

        self::Approve_as_student,
        self::Site_base_student_registration_declare_id,
        self::Site_id,
        self::Client_ip,
        self::APPROVED_AT,
        self::APPROVED_BY,
        self::Status,
        self::Site_can_approve_student,
        self::Menual_form_number,
    ];


//    public function getStudentRollNumberAttribute($value)
//    {
//        return $this->attributes['student_roll_number'] = $value != null ? (int)$value : 0;
//    }


    public function getFullNameAttribute()
    {
        $full_name = ($this->first_name ?? '') . ' ' . ($this->last_name ?? '');
        return $this->attributes['full_name'] = ucwords($full_name);
    }


    public function getFatherNameAttribute($value)
    {
        return $this->attributes['father_name'] = ucwords($value);
    }

    public function getMotherNameAttribute($value)
    {
        return $this->attributes['mother_name'] = ucwords($value);
    }



    public function getAcademicSubjectIdsAttribute($value)
    {

        //dd($value);


        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }

    public function getOptionalSubjectIdsAttribute($value)
    {

        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];


    }

    public function getCompulsorySubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

    public function getSelectiveCompulsorySubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

    public function getGeneralMarkinglessSubjectIdsAttribute($value)
    {

        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }

    public function getSelectiveMarkinglessSubjectIdsAttribute($value)
    {

        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }


    /*
        public function latestPhoto()
        {
            return $this->hasOne(Photo::class, 'imageable_id')->orderBy('id', 'DESC');
        }*/


    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, self::Academic_version_id);
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class, self::Academic_year_id);
    }



    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, self::Academic_shift_id);
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::Academic_department_id);
    }

    public function stClass()
    {
        return $this->belongsTo(AcademicClass::class, self::Academic_class_id);
    }

    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::Academic_class_group_id);
    }

    public function session()
    {
        return $this->belongsTo(AcademicSession::class, self::Academic_session_id);
    }

     public function studentType()
    {
        return $this->belongsTo(AcademicStudentType::class, self::Academic_student_type_id);
    }

    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }

    public function religion()
    {
        return $this->belongsTo(Religion::class);
    }


    public function academicAdmissionType()
    {
        return $this->belongsTo(AcademicAdmissionType::class, self::Academic_student_admission_type_id);
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function siteStudentAdmissionEducationQualification()
    {
        return $this->hasMany(GlobalSiteStudentAdmissionEducationQualification::class,'site_student_admission_application_id','id');
    }

    public function approved()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }


    public function presentCountry()
    {
        return $this->belongsTo(Country::class, 'present_country_id');
    }

    public function permanentCountry()
    {
        return $this->belongsTo(Country::class, 'permanent_country_id');
    }

    public function presentDivision()
    {
        return $this->belongsTo(Division::class, 'present_division_id');
    }

    public function permanentDivision()
    {
        return $this->belongsTo(Division::class, 'permanent_division_id');
    }

    public function presentDistrict()
    {
        return $this->belongsTo(District::class, 'present_district_id');
    }

    public function permanentDistrict()
    {
        return $this->belongsTo(District::class, 'permanent_district_id');
    }

    public function presentThana()
    {
        return $this->belongsTo(Thana::class, 'present_thana_id');
    }

    public function permanentThana()
    {
        return $this->belongsTo(Thana::class, 'permanent_thana_id');
    }

    public function bloodGroup()
    {
        return $this->belongsTo(BloodGroup::class);
    }

    public function relation()
    {
        return $this->belongsTo(Relation::class, 'guardian_student_relation_id');
    }

    public function fatherOccupation()
    {
        return $this->belongsTo(AcademicOccupation::class, 'father_occupation_id');
    }
    public function motherOccupation()
    {
        return $this->belongsTo(AcademicOccupation::class, 'mother_occupation_id');
    }


}
