<?php

namespace App\Models\Site\StudentAdmission;

use App\Models\Academic\AcademicBoard;
use App\Models\ProjectModel;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentAdmissionEducationQualification extends Model
{


    public $timestamps = true;
    protected $table = 'site_student_admission_education_qualifications';




    const Site_student_admission_application_id = 'site_student_admission_application_id';
    const USER_ID = 'user_id';
    const Examination_id = 'examination_id';
    const Institution_name = 'institution_name';
    const Board_roll_number = 'board_roll_number';
    const Board_registration_number = 'board_registration_number';
    const Academic_board_id = 'academic_board_id';
    const Academic_session_id = 'academic_session_id';
    const Passing_year = 'passing_year';
    const Gpa_with_optional = 'gpa_with_optional';
    const Gpa_without_optional = 'gpa_without_optional';


    protected $fillable = [
        self::Site_student_admission_application_id,
        self::USER_ID,
        self::Institution_name,
        self::Examination_id,
        self::Board_roll_number,
        self::Board_registration_number,
        self::Academic_board_id,
        self::Academic_session_id,
        self::Passing_year,
        self::Gpa_with_optional,
        self::Gpa_without_optional,

    ];


    public $ownFields = [
        self::Site_student_admission_application_id,
        self::USER_ID,
        self::Institution_name,
        self::Examination_id,
        self::Board_roll_number,
        self::Board_registration_number,
        self::Academic_board_id,
        self::Academic_session_id,
        self::Passing_year,
        self::Gpa_with_optional,
        self::Gpa_without_optional,


    ];



    public function board()
    {
        return $this->belongsTo(AcademicBoard::class, 'academic_board_id');
    }


}
