<?php

namespace App\Models\Site\Web\Calendar;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;
use App\Models\Academic\AcademicCalendarHead;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use App\Models\Image\Photo;
use App\Models\Media\Media;

class CalenderEvent extends SiteGlobalModel
{
    use SoftDeletes;

    const ACTIVATE_DATE = 'activate_date';
    const START_DATE = 'start_date';
    const END_DATE = 'end_date';
    const IDENTIFICATION_NUMBER = 'identification_number';
    const TITLE = 'title';
    const DESCRIPTION = 'description';
    const ACADEMIC_CALENDAR_HEAD_ID = 'academic_calendar_head_id';
    const SUBHEAD_COLOR_ID = 'subhead_color_id';
    const EVENT_VENUE = 'event_venue';
    const EVENT_TYPE = 'event_type';
    const DAY_NAME = 'day_name';
    const ATTENDANCE_ACTIVE_FOR_STUDENT = 'attendance_active_for_student';
    const ATTEMDANCE_ACTIVE_EMPLOYEE = 'attendance_active_for_employee';
    const YEAR = 'year';
    const MONTH = 'month';
    const STATUS = 'status';
//    const PHOTO = 'photo';

    public $timestamps = true;

    protected $table = 'events';

    protected $dates = ['deleted_at'];

    protected $fillable = [
        self::ACTIVATE_DATE,
        self::START_DATE,
        self::END_DATE,
        self::IDENTIFICATION_NUMBER,
        self::TITLE,
        self::DESCRIPTION,
        self::TITLE,
        self::ACADEMIC_CALENDAR_HEAD_ID,
        self::SUBHEAD_COLOR_ID,
        self::DAY_NAME,
        self::ATTENDANCE_ACTIVE_FOR_STUDENT,
        self::ATTEMDANCE_ACTIVE_EMPLOYEE,
        self::YEAR,
        self::MONTH,
        self::STATUS,
//        self::EVENT_VENUE,
        self::EVENT_TYPE,
//        self::PHOTO,

    ];

//    public $translatedAttributes = [
//        self::TITLE,
//        self::DESCRIPTION,
////        self::EVENT_VENUE
//    ];

    public $ownFields = [
        self::ACTIVATE_DATE,
        self::START_DATE,
        self::END_DATE,
        self::IDENTIFICATION_NUMBER,
        self::EVENT_TYPE,
        self::ACADEMIC_CALENDAR_HEAD_ID,
        self::SUBHEAD_COLOR_ID,
        self::TITLE,
        self::DESCRIPTION,
        self::DAY_NAME,
        self::ATTENDANCE_ACTIVE_FOR_STUDENT,
        self::ATTEMDANCE_ACTIVE_EMPLOYEE,
        self::YEAR,
        self::MONTH,
        self::STATUS
//        self::EVENT_TITLE,
        //self::PHOTO,

    ];
    /*
        public function getFromDateAttribute($value){
            return date('d-m-Y',strtotime($value));
        }

        public function getToDateAttribute($value){
            return date('d-m-y',strtotime($value));
        }*/



    public function getDateData($date){

        $event = (new Event())->select('event_type')->whereDate('from_date', '=', $date)->distinct('event_type')->get();

        return $event;

    }

    public function files()
    {
        return $this->morphMany(Media::class, 'filable');
    }

    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }


    public function photos()
    {
        return $this->hasMany(Photo::class);
    }

    public function academicCalendarHead()
    {
        return $this->belongsTo(AcademicCalendarHead::class);
    }

}