<?php

namespace App\Models\Site\Web\ClassRoom;

use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class SiteClassLessonFeedback extends Model
{
    protected $table='site_class_lesson_feedbacks';
    protected $appends = array('feedback_reply', 'feedback_reply_part_show');


    const Website_class_room_id = 'website_class_room_id';
    const Feedback_by = 'feedback_by';
    const Feedback_detail = 'feedback_detail';
    const Site_id = 'site_id';
    const Status = 'status';



    protected $fillable = [
        self::Website_class_room_id,
        self::Feedback_by,
        self::Feedback_detail,
        self::Site_id,
        self::Status,

    ];

    protected $ownFields = [
        self::Website_class_room_id,
        self::Feedback_by,
        self::Feedback_detail,
        self::Site_id,
        self::Status,

    ];


    public function getFeedbackReplyAttribute()
    {
        return  $this->attributes['feedback_reply']=  false;

    }

    public function getFeedbackReplyPartShowAttribute()
    {
        return  $this->attributes['feedback_reply_part_show']=  false;

    }

    public function siteClassLessonReplyFeedback()
    {
        return $this->hasMany(SiteClassLessonReplyFeedback::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'feedback_by');
    }


}
