<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Session;

class SiteGlobalModel extends Model
{
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';


    /**
     * ProjectModel constructor.
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        $this->fillable[] = self::SITE_ID;
        $this->fillable[] = self::ACADEMIC_GROUP_ID;

        $this->{self::SITE_ID} = (int)session()->get('SITE_ID');
        $this->{self::ACADEMIC_GROUP_ID} = (int)session()->get('ACADEMIC_GROUP_ID');
        parent::__construct($attributes);

    }


    public function newQuery()
    {
        $site_id = (int)session()->get('SITE_ID');
        $academic_group_id = (int)session()->get('ACADEMIC_GROUP_ID');

        $builder = $this->newQueryWithoutScopes();
        $tableName = $builder->getModel()->getTable();
        $final = $builder->where($tableName . '.site_id', $site_id)->where($tableName . '.academic_group_id', $academic_group_id);

        return $final;//$this->applyGlobalScopes($final);
    }


    //Some demo complex query for future help
    /*
    Debug eloquent as sql:
    $mydata = User::where('id',1);
    return dd($mydata->toSql(),$mydata->getBindings());


    \DB::listen(function($sql) {
        dump($sql);
    });z
    */


    /*
    $allCats = Category::with('latestPost')->get();

    // using strict operator === ...
    $filteredCats = $allCats->where('latestPost.status', 'published');

    // ... or using loose operator ==
    $filteredCats = $allCats->whereLoose('latestPost.status', 'published');*/


    /*
    Category::whereHas('posts', function ($posts) {

        $posts->where('status', 'published')
            ->where('id', function ($sub) {
                $sub->from('posts as sub')
                    ->selectRaw('max(id)')
                    ->whereRaw('sub.category_id = posts.category_id')
        });
    });
    })->with('latestPost')->get()*/



    /*  public function setSiteIdAttribute()
      {
          $this->attributes[self::SITE_ID] = Session::get(SITE_ID);
      }*/

    /*protected static function boot()
     {
         parent::boot();
         static::addGlobalScope(new ProjectScope());
     }*/

    /*
        public function approvedUsers() {
            return $this->hasMany('App\User')->where('approved', 1)->orderBy('email');
        }*/
}
