<?php

namespace App\Models\SiteGroup\Admission;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use Illuminate\Database\Eloquent\Model;

class SiteGroupAdmissionDeclare extends Model
{
    protected $table='site_group_admission_declares';


    const Duration_from_date = 'duration_from_date';
    const Duration_to_date = 'duration_to_date';
    const Extended_date = 'extended_date';
    const Academic_group_id = 'academic_group_id';
    const Academic_version_ids = 'academic_version_ids';
    const Academic_shift_ids = 'academic_shift_ids';
    const Academic_year_ids = 'academic_year_ids';
    const Academic_department_ids = 'academic_department_ids';
    const Academic_class_ids = 'academic_class_ids';
    const Academic_session_ids = 'academic_session_ids';
    const Send_sms = 'send_sms';
    const Guardian_information_add = 'guardian_information_add';
    const Address_information_add = 'address_information_add';
    const Communication_information_add = 'communication_information_add';
    const Student_registration_number_box_show = 'student_registration_number_box_show';
    const Local_guardian_detail_information_add = 'local_guardian_detail_information_add';
    const Check_with_roll_number = 'check_with_roll_number';
    const Check_with_online_transaction_id = 'check_with_online_transaction_id';
    const Check_with_board_university = 'check_with_board_university';
    const Auto_roll_create_status = 'auto_roll_create_status';
    const Bank_recipt_downlaod_status = 'bank_recipt_downlaod_status';
    const Exam_passing_year_show = 'exam_passing_year_show';
    const Education_qualification_ids = 'education_qualification_ids';
    const Admission_form_language = 'admission_form_language';
    const Academic_payment_type_id = 'academic_payment_type_id';
    const Payment_company_ids = 'payment_company_ids';
    const Auto_roll_digit = 'auto_roll_digit';
    const Passing_year_examination_id = 'passing_year_examination_id';
    const Form_number_entry_box_show = 'form_number_entry_box_show';
    const Form_number_check = 'form_number_check';
    const Form_show_to_website = 'form_show_to_website';
    const Site_can_not_approve_student = 'site_can_not_approve_student';
    const Academic_admission_style_id = 'academic_admission_style_id';
    const Site_group_id = 'site_group_id';
    const Status = 'status';




    protected $fillable = [

        self::Duration_from_date,
        self::Duration_to_date,
        self::Extended_date,
        self::Academic_group_id,
        self::Academic_version_ids,
        self::Academic_shift_ids,
        self::Academic_year_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,
        self::Academic_session_ids,
        self::Send_sms,
        self::Guardian_information_add,
        self::Address_information_add,
        self::Communication_information_add,
        self::Student_registration_number_box_show,
        self::Local_guardian_detail_information_add,
        self::Check_with_roll_number,
        self::Check_with_online_transaction_id,
        self::Check_with_board_university,
        self::Auto_roll_create_status,
        self::Bank_recipt_downlaod_status,
        self::Exam_passing_year_show,
        self::Education_qualification_ids,
        self::Admission_form_language,
        self::Academic_payment_type_id,
        self::Payment_company_ids,
        self::Auto_roll_digit,
        self::Passing_year_examination_id,
        self::Form_number_entry_box_show,
        self::Form_number_check,
        self::Form_show_to_website,
        self::Site_can_not_approve_student,
        self::Academic_admission_style_id,
        self::Site_group_id,
        self::Status,

    ];



    protected $ownFields = [
        self::Duration_from_date,
        self::Duration_to_date,
        self::Extended_date,
        self::Academic_group_id,
        self::Academic_version_ids,
        self::Academic_shift_ids,
        self::Academic_year_ids,
        self::Academic_department_ids,
        self::Academic_class_ids,
        self::Academic_session_ids,
        self::Send_sms,
        self::Guardian_information_add,
        self::Address_information_add,
        self::Communication_information_add,
        self::Student_registration_number_box_show,
        self::Local_guardian_detail_information_add,
        self::Check_with_roll_number,
        self::Check_with_online_transaction_id,
        self::Check_with_board_university,
        self::Auto_roll_create_status,
        self::Bank_recipt_downlaod_status,
        self::Exam_passing_year_show,
        self::Education_qualification_ids,
        self::Admission_form_language,
        self::Academic_payment_type_id,
        self::Payment_company_ids,
        self::Auto_roll_digit,
        self::Passing_year_examination_id,
        self::Form_number_entry_box_show,
        self::Form_number_check,
        self::Form_show_to_website,
        self::Site_can_not_approve_student,
        self::Academic_admission_style_id,
        self::Site_group_id,
        self::Status,

    ];



    public function getSendSmsAttribute($value) {

        return $this->attributes['send_sms'] = $value==1?true:false;
    }


    public function getAcademicShiftIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicShift::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicVersionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicVersion::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicYearIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicYear::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicDepartmentIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicDepartment::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }
    public function getAcademicClassIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicClass::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }

    public function getAcademicSessionIdsAttribute($value) {

        $arr=$value?array_map('intval', explode(',', $value)):[];
        $array=AcademicSession::whereIn('id', $arr)->get();
        return [$array, $value?array_map('intval', explode(',', $value)):null];
    }




}
