<?php

namespace App\Models\SiteGroup\Exam;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\SiteGroup\SiteGroupGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteGroupExamDeclareStore extends SiteGroupGlobalModel
{
    protected $table='site_group_exam_declare_stores';

    const Academic_group_id = 'academic_group_id';
    const Site_group_id = 'site_group_id';
    const Academic_year_id = 'academic_year_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_session_id = 'academic_session_id';
    const Academic_section_id = 'academic_section_id';
    const Academic_class_group_id = 'academic_class_group_id';
    const Created_by = 'created_by';
    const Examination_id = 'examination_id';
    const Site_subject_group_condition_setting_ids = 'site_subject_group_condition_setting_ids';
    const Status = 'status';



    protected $fillable = [
        self::Academic_group_id,
        self::Site_group_id,
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_session_id,
        self::Academic_section_id,
        self::Academic_class_group_id,
        self::Examination_id,
        self::Status,
        self::Site_subject_group_condition_setting_ids,

    ];

    protected $ownFields = [
        self::Academic_group_id,
        self::Site_group_id,
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_session_id,
        self::Academic_section_id,
        self::Academic_class_group_id,
        self::Examination_id,
        self::Site_subject_group_condition_setting_ids,
        self::Status,
    ];

    
    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, self::Academic_version_id);
    }
    public function year()
    {
        return $this->belongsTo(AcademicYear::class, self::Academic_year_id);
    }

    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, self::Academic_shift_id);
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::Academic_department_id);
    }

    public function stClass()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }

    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::Academic_class_group_id);
    }
    public function session()
    {
        return $this->belongsTo(AcademicSession::class, self::Academic_session_id);
    }

    public function section()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }


    // public function declaredStudent()
    // {
    //     return $this->hasMany(SiteExamDeclareStudent::class, 'site_exam_declare_id');

    // }

    public function examRoutine()
    {
        return $this->hasMany(SiteGroupExamRoutineStore::class, 'site_group_exam_declare_id');

    }

    public function examination()
    {
        return $this->belongsTo(Examination::class);

    }

    public function academicExamTypeList()
    {
        return $this->hasMany(SiteGroupExamRoutineStore::class, 'site_group_exam_declare_id');

    }


    // public function getSiteSubjectGroupConditionSettingIdsAttribute($value) {

    //     $array=[];
    //     if($value){
    //         $arr=$value?array_map('intval', explode(',', $value)):[];
    //         $array=SubjectGroupConditionSetting::whereIn('id', $arr)->get();
    //     }

    //     return $array;

    // }


    // public function startDate()
    // {
    //     return $this->hasMany(SiteExamRoutine::class, 'site_exam_declare_id');

    // }

    // public function endDate()
    // {
    //     return $this->hasMany(SiteExamRoutine::class, 'site_exam_declare_id');

    // }

}
