<?php

namespace App\Models\SiteGroup\ExamResult;

use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\SiteGlobalModel;
use App\Models\SiteGroup\SiteGroupGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteGroupResultCombineSettingStore extends SiteGroupGlobalModel
{
    public $timestamps = false;
    protected $table='site_group_result_combine_setting_stores';

    const Academic_year_id = 'academic_year_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_session_id = 'academic_session_id';
    const Academic_class_group_id = 'academic_class_group_id';
    const Academic_result_combine_type_id = 'academic_result_combine_type_id';
    const Academic_result_primary_type_id = 'academic_result_primary_type_id';
    const Marks_percentage = 'marks_percentage';
    const Show_position = 'show_position';
    const Status = 'status';
    const Academic_group_id = 'academic_group_id';
    const Site_group_id = 'site_group_id';

    protected $fillable = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_session_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_result_combine_type_id,
        self::Academic_result_primary_type_id,
        self::Marks_percentage,
        self::Show_position,
        self::Status,
        self::Academic_group_id,
        self::Site_group_id,
    ];

    public $ownFields = [
        self::Academic_year_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_department_id,
        self::Academic_session_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_result_combine_type_id,
        self::Academic_result_primary_type_id,
        self::Marks_percentage,
        self::Show_position,
        self::Status,
        self::Academic_group_id,
        self::Site_group_id,
    ];


    public function academicResultCombineType()
    {
        return $this->belongsTo(AcademicResultCombineType::class);
    }
    public function academicResultPrimaryType()
    {
        return $this->belongsTo(AcademicResultPrimaryType::class);
    }


}
