<?php

namespace App\Models\SiteGroup\Role;

use App\Models\SiteGroup\SiteGroupModel;
use Illuminate\Database\Eloquent\Model;
use App\Models\User\User;
class SiteGroupRole extends SiteGroupModel
{
    public $timestamps = true;
    protected $table='site_group_roles';


    const NAME    = 'name';
    const SITE_GROUP_ID  = 'site_group_id';
    const KEY  = 'key';
    const STATUS  = 'status';




    protected $fillable =[
        self::NAME,
        self::SITE_GROUP_ID,
        self::STATUS,

    ];


    public function groupAccess()
    {
        return $this->hasMany(SiteGroupRoleAccess::class);
    }




    public function users()
    {
        return $this->belongsToMany(User::class,'site_group_role_user', 'role_id', 'user_id');
    }


}
