<?php

namespace App\Models\Student;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Attendance\StudentAttendance;
use App\Models\Gender\Gender;
use App\Models\Image\Photo;
use App\Models\ProjectModel;
use App\Models\Religion\Religion;
use App\Models\Site\Batch\BatchDetail;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\GlobalSiteInfo;
use App\Models\Site\Live\MeetingInvitation;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\Testimonial\SiteTestimonialResult;
use App\Models\Site\Result\Testimonial\SiteManuallyTestimonial;
use App\Models\Site\SiteInfo;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Models\Site\Student\Attendance\StudentAbsentDetail;
use App\Models\Site\Student\Attendance\StudentLeaveDetail;
use App\Models\Site\Student\IDCard\StudentIDCard;
use App\Models\Site\Student\Student;
use App\Models\User\PublicUser;
use App\Models\Site\Guardian\Guardian;

use App\Models\User\GlobalUser;

use App\Models\SiteGlobalModel;

use App\Models\User\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class PublicStudentHistory extends Model
{

    public $timestamps = true;
    protected $appends = array('full_name', 'student_full_roll_number','full_name_username','roll_full_name_username');
 
    protected $table = 'student_histories';


    const USER_ID = 'user_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const SITE_BATCH_DETAIL_ID = 'site_batch_detail_id';
    const ACADEMIC_RESIDANCE_ID = 'academic_residence_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_STUDENT_CATEGORY_ID = 'academic_student_category_id';
    const ACADEMIC_STUDENT_TYPE_ID = 'academic_student_type_id';
    const ACADEMIC_STUDENT_ADMISSION_TYPE_ID = 'academic_student_admission_type_id';
    const ACADEMIC_QUATA_ID = 'academic_quata_id';
    const BOARD_REGISTRATION_NUMBER = 'board_registration_number';
    const Board_roll_number = 'board_roll_number';
    const ACADEMIC_SUBJECT_IDS = 'academic_subject_ids';
    const OPTIONAL_SUBJECT_IDS = 'optional_subject_ids';
    const COMPULSORY_SUBJECT_IDS = 'compulsory_subject_ids';

//    const GENERAL_MARKINGLESS_SUBJECT_IDs = 'general_markingless_subject_ids';
    const SELECTIVE_MARKINGLESS_SUBJECT_IDs = 'selective_markingless_subject_ids';
    const SELECTIVE_COMPULSORY_SUBJECT_IDS = 'selective_compulsory_subject_ids';

    const RELIGION_SUBJECT_ID = 'religion_subject_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const STUDENT_ROLL_NUMBER = 'student_roll_number';
    const REGISTRATION_NO = 'registration_no';
    const LOCAL_GUARDIAN_ID = 'local_guardian_id';
    const SITE_ID = 'site_id';
    const PREVIOUS_ACADEMIC_CLASS_ID = 'previous_academic_class_id';
    const PREVIOUS_ROLL_NO = 'previous_roll_no';
    const PREVIOUS_GPA = 'previous_gpa';
    const PREVIOUS_EXAM_MARK = 'previous_exam_mark';
    const PREVIOUS_INSTITUTE_NAME = 'previous_institute_name';
    const PREVIOUS_INSTITUTE_LOCATION = 'previous_institute_location';
    const TC_NUMBER = 'tc_number';
    const TC_DATE = 'tc_date';
    const STATUS = 'status';
    const PREVIOUS_STUDENT_HISTORY_ID = 'previous_student_history_id';


    const Ex_academic_year_id = 'ex_academic_year_id';
    const Ex_academic_shift_id = 'ex_academic_shift_id';
    const Ex_academic_class_id = 'ex_academic_class_id';
    const Ex_academic_department_id = 'ex_academic_department_id';
    const Ex_academic_class_group_id = 'ex_academic_class_group_id';
    const Ex_academic_section_id = 'ex_academic_section_id';
    const Ex_academic_session_id = 'ex_academic_session_id';
    const Ex_roll_number = 'ex_roll_number';
    const Ex_id_card_code = 'ex_id_card_code';
    const Student_roll_number_prefix = 'student_roll_number_prefix';
    const Site_student_admission_application_id = 'site_student_admission_application_id';


    const Created_by = 'created_by';
    const Updated_by = 'updated_by';
    const Student_edu_payment_status = 'student_edu_payment_status';


    protected $fillable = [
        self::USER_ID,
        self::ACADEMIC_GROUP_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::SITE_BATCH_DETAIL_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_RESIDANCE_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_STUDENT_CATEGORY_ID,
        self::ACADEMIC_STUDENT_TYPE_ID,
        self::ACADEMIC_STUDENT_ADMISSION_TYPE_ID,
        self::ACADEMIC_QUATA_ID,
        self::BOARD_REGISTRATION_NUMBER,
        self::ACADEMIC_SUBJECT_IDS,
        self::OPTIONAL_SUBJECT_IDS,
//        self::GENERAL_MARKINGLESS_SUBJECT_IDs,
        self::SELECTIVE_MARKINGLESS_SUBJECT_IDs,

        self::COMPULSORY_SUBJECT_IDS,
        self::SELECTIVE_COMPULSORY_SUBJECT_IDS,
        self::RELIGION_SUBJECT_ID,
        self::STUDENT_ROLL_NUMBER,
        self::REGISTRATION_NO,
        self::LOCAL_GUARDIAN_ID,
        self::SITE_ID,
        self::PREVIOUS_ACADEMIC_CLASS_ID,
        self::PREVIOUS_ROLL_NO,
        self::PREVIOUS_GPA,
        self::PREVIOUS_EXAM_MARK,
        self::PREVIOUS_INSTITUTE_NAME,
        self::PREVIOUS_INSTITUTE_LOCATION,
        self::TC_NUMBER,
        self::TC_DATE,
        self::STATUS,
        self::PREVIOUS_STUDENT_HISTORY_ID,

        self::Ex_academic_year_id,
        self::Ex_academic_shift_id,
        self::Ex_academic_class_id,
        self::Ex_academic_department_id,
        self::Ex_academic_class_group_id,
        self::Ex_academic_section_id,
        self::Ex_academic_session_id,
        self::Ex_roll_number,
        self::Ex_id_card_code,
        self::Student_roll_number_prefix,


        self::Created_by,
        self::Updated_by,
        self::Student_edu_payment_status,
        self::Site_student_admission_application_id,
    ];

    public $ownFields = [
        self::USER_ID,
        self::ACADEMIC_GROUP_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::SITE_BATCH_DETAIL_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_RESIDANCE_ID,
        self::ACADEMIC_STUDENT_CATEGORY_ID,
        self::ACADEMIC_STUDENT_TYPE_ID,
        self::ACADEMIC_STUDENT_ADMISSION_TYPE_ID,
        self::ACADEMIC_QUATA_ID,
        self::BOARD_REGISTRATION_NUMBER,
        self::ACADEMIC_SUBJECT_IDS,
        self::OPTIONAL_SUBJECT_IDS,
        self::COMPULSORY_SUBJECT_IDS,
        self::SELECTIVE_COMPULSORY_SUBJECT_IDS,
//        self::GENERAL_MARKINGLESS_SUBJECT_IDs,
        self::SELECTIVE_MARKINGLESS_SUBJECT_IDs,
        self::RELIGION_SUBJECT_ID,
        self::STUDENT_ROLL_NUMBER,
        self::REGISTRATION_NO,
        self::LOCAL_GUARDIAN_ID,
        self::SITE_ID,
        self::PREVIOUS_ACADEMIC_CLASS_ID,
        self::PREVIOUS_ROLL_NO,
        self::PREVIOUS_GPA,
        self::PREVIOUS_EXAM_MARK,
        self::PREVIOUS_INSTITUTE_NAME,
        self::PREVIOUS_INSTITUTE_LOCATION,
        self::TC_NUMBER,
        self::TC_DATE,
        self::STATUS,
        self::PREVIOUS_STUDENT_HISTORY_ID,

        self::Ex_academic_year_id,
        self::Ex_academic_shift_id,
        self::Ex_academic_class_id,
        self::Ex_academic_department_id,
        self::Ex_academic_class_group_id,
        self::Ex_academic_section_id,
        self::Ex_academic_session_id,
        self::Ex_roll_number,
        self::Ex_id_card_code,
        self::Student_roll_number_prefix,

        self::Created_by,
        self::Updated_by,
        self::Student_edu_payment_status,
        self::Site_student_admission_application_id,
    ];


    public function getStudentFullRollNumberAttribute()
    {
        return $this->attributes['student_full_roll_number'] = ($this->student_roll_number_prefix ?? '') . ($this->student_roll_number);
    }

    public function getAcademicSubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

    public function getOptionalSubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

    public function getCompulsorySubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }
    public function getSelectiveCompulsorySubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];
    }

   
    public function getGeneralMarkinglessSubjectIdsAttribute($value)
    {
        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }

    public function getSelectiveMarkinglessSubjectIdsAttribute($value)
    {

        $arr = $value ? array_map('intval', explode(',', $value)) : [];
        $array = AcademicSubject::whereIn('id', $arr)->get();
        return [$array, $value ? array_map('intval', explode(',', $value)) : null];

    }


    //mutator
    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->publicUser->first_name ?? '') . ' ' . ($this->student->last_name ?? '');

    }
    public function getFullNameUsernameAttribute()
    {
        return $this->attributes['full_name_username'] = $this->attributes['full_name'].'('. ($this->student->username ?? "").')';

    }

    public function getRollFullNameUsernameAttribute()
    {
        return $this->attributes['roll_full_name_username'] = $this->student_roll_number.'.'.$this->attributes['full_name_username'];

    }

    public function subjects()
    {
        return $this->belongsToMany(AcademicSubject::class, 'student_subject', 'student_history_id')->withTimestamps();
    }

    public function religionSubject()
    {
        return $this->belongsTo(AcademicSubject::class, 'religion_subject_id');
    }

    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, self::ACADEMIC_VERSION_ID);
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class, self::ACADEMIC_YEAR_ID);
    }

    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, self::ACADEMIC_SHIFT_ID);
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::ACADEMIC_DEPARTMENT_ID);
    }

    public function stClass()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }

    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::ACADEMIC_CLASS_GROUP_ID);
    }

    public function session()
    {
        return $this->belongsTo(AcademicSession::class, self::ACADEMIC_SESSION_ID);
    }



    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }


    public function academicStudentCategory()
    {
        return $this->belongsTo(AcademicStudentCategory::class);
    }


    public function section()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }


    public function batch()
    {
        return $this->belongsTo(BatchDetail::class, 'site_batch_detail_id');
    }


    public function publicUser()
    {
        return $this->belongsTo(PublicUser::class, 'user_id');
    }


    public function accGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::ACADEMIC_CLASS_GROUP_ID);
    }


    // public function siteExamDeclareStudentSubject()
    // {
    //     return $this->hasMany(SiteExamDeclareStudentSubject::class, 'student_history_id');
    // }


    public function periodic()
    {
        return $this->hasOne(PeriodicAttendance::class, 'student_history_id');
    }

    public function periodics()
    {
        return $this->hasMany(PeriodicAttendance::class, 'student_history_id');
    }


    // public function attendance()
    // {
    //     return $this->hasOne(StudentAttendance::class, 'student_history_id');
    // }

    // public function attendances()
    // {
    //     return $this->hasMany(StudentAttendance::class, 'student_history_id');
    // }

    // public function studentAttendances()//use above attendances function instead of this
    // {
    //     return $this->hasMany(StudentAttendance::class, 'student_history_id');
    // }


    // public function presentToday()
    // {
    //     $today = Carbon::now()->toDateString();
    //     return $this->hasOne(StudentAttendance::class, 'student_history_id')
    //         ->whereDate('present_date', $today);
    // }

    // public function absent()
    // {
    //     return $this->hasOne(StudentAbsentDetail::class, 'student_history_id')->orderBy('id', 'DESC');
    // }

    // public function leaveDetail()
    // {
    //     return $this->hasOne(StudentLeaveDetail::class, 'student_history_id');
    // }


    // public function idCard()
    // {
    //     return $this->hasOne(StudentIDCard::class, 'history_id');

    // }


    public function religion()
    {
        return $this->belongsTo(Religion::class);
    }

    public function site()
    {
        return $this->belongsTo(SiteInfo::class, 'site_id');
    }

    // public function siteStudentFeeDemandSlipDetails()
    // {
    //     return $this->hasOne(SiteStudentFeeDemandSlipDetails::class, 'student_history_id');
    // }

    // public function siteStudentFeePaymentHistory()
    // {
    //     return $this->hasOne(SiteStudentFeePaymentHistory::class, 'student_history_id');
    // }


    // public function siteStudentPrimaryResultDetail()
    // {
    //     return $this->hasOne(SiteStudentPrimaryResultDetail::class, 'student_history_id');
    // }

    // public function siteTestimonialResult()
    // {
    //    // return $this->hasOne(SiteTestimonialResult::class, 'student_history_id');
    //     return $this->hasOne(SiteTestimonialResult::class, 'student_history_id');
    // }
    
    // public function SiteManuallyTestimonial()
    // {
    //     return $this->hasOne(SiteManuallyTestimonial::class, 'student_history_id');
    // }
    


}