<?php

namespace App\Models\Student;


use App\Models\ProjectModel;
use App\Models\Result\TotalResultSystem;
use App\User;
use App\Models\Routine\Routine;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Examinations\ExaminationSchedule;

class Section extends Model
{
    //use SoftDeletes;

    const SECTION ='section_name';
    const STATUS = 'status';

    public $timestamps = false;
    protected $table = 'sections';
    protected $fillable = [
        self::SECTION,
        self::STATUS
    ];

    public $ownFields = [
        self::SECTION,
        self::STATUS
    ];

    protected $dates = ['deleted_at'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function classTeacher()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function studentClass()
    {
        return $this->belongsTo(StudentClass::class);
    }

    // Section hasMany Routines
    public function routines()
    {
        return $this->hasMany(Routine::class);
    }

    // Section hasMany ExaminationSchedule
    public function examinationSchedules()
    {
        return $this->hasMany(ExaminationSchedule::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function totalResultSystem()
    {
        return $this->belongsTo(TotalResultSystem::class);
    }

}
