<?php

namespace App\Models\User;

use App\Models\Department\Department;
use App\Models\Designation\Designation;
use App\Models\ProjectModel;
use App\Models\Shift\Shift;
use App\Models\Site\Employee\Employee;
use App\Models\Site\EmployeeDuty\SiteEmployeeAssignDutyHistory;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveGenerate;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use App\Models\Site\Result\protyonpotro\SiteProtyonpotro;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeHistory extends ProjectModel
{
    use SoftDeletes;

    const USER = 'user_id';
    const IS_TEACHER = 'is_teacher';
    const DEPARTMENT = 'department_id';
    const DESIGNATION = 'designation_id';
    const EMPCATEGORY = 'emp_category_id';
    const EMPPOSITION = 'emp_position_id';

    const JOB_TITLE = 'job_title';
    const TRANSPORT_ASSIGN_ID = 'transport_assign_id';
    const EMP_GRADE_ID = 'emp_grade_id';
    const NUMBER_OF_CHILDREN = 'number_of_children';
    const NTRC_REGISTRATION_NUMBER = 'ntrc_registration_number';

    const DEPTJOINDATE = 'dept_join_date';
    const SHIFT = 'shift_id';
    const STATUS = 'status';
    const POSITION = 'position';
    const DEPT_JOIN_DATE = 'dept_join_date';



    public $timestamps = false;
    protected $dates = ['deleted_at'];
    protected $appends = array('full_name', 'designation_name');

    protected $fillable = [
        self::USER,

        self::JOB_TITLE,
        self::TRANSPORT_ASSIGN_ID,
        self::EMP_GRADE_ID,
        self::NUMBER_OF_CHILDREN,
        self::NTRC_REGISTRATION_NUMBER,
        self::DEPTJOINDATE,

        self::DEPARTMENT,
        self::DESIGNATION,
        self::EMPCATEGORY,
        self::EMPPOSITION,
        self::STATUS,
        self::POSITION,
        self::DEPT_JOIN_DATE,
        self::SHIFT,
        self::CREATED_AT,
        self::UPDATED_AT

    ];


    public $ownFields = [
        self::USER,
        self::IS_TEACHER,

        self::JOB_TITLE,
        self::TRANSPORT_ASSIGN_ID,
        self::EMP_GRADE_ID,
        self::NUMBER_OF_CHILDREN,
        self::NTRC_REGISTRATION_NUMBER,
        self::DEPTJOINDATE,

        self::DEPARTMENT,
        self::DESIGNATION,
        self::EMPCATEGORY,
        self::EMPPOSITION,
        self::STATUS,
        self::POSITION,
        self::DEPT_JOIN_DATE,
        self::SHIFT,
        self::CREATED_AT,
        self::UPDATED_AT
    ];
    /**
     * last updated shift for an employee
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function employee()
    {
        return $this->belongsTo(Employee::class, 'user_id');
    }
    public function SiteEmployeeAssignDutyHistory()
    {
        return $this->hasMany(SiteEmployeeAssignDutyHistory::class);
    }
    public function siteEmployeeLeaveGenerate()
    {
        return $this->hasMany(SiteEmployeeLeaveGenerate::class);
    }
    public function siteEmployeeLeaveHistory()
    {
        return $this->hasMany(SiteEmployeeLeaveHistory::class);
    }

    public function designation()
    {
        return $this->belongsTo(Designation::class, 'designation_id');
    }

    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->employee->first_name ?? '') . ' ' . ($this->employee->last_name ?? '');
    }
    public function getDesignationNameAttribute()
    {
        return $this->attributes['designation_name'] = ($this->designation->name ?? '');
    }


      public function siteProtyonpotro()
    {
        return $this->hasOne(SiteProtyonpotro::class, 'user_id', 'user_id');
    }
}
