<?php

namespace App\Models\User;

use App\Models\Academic\AcademicSubject;
use App\Models\Designation\Designation;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\EmployeeDuty\SiteEmployeeAssignDutyHistory;
use App\Models\SiteGroup\EmployeeTransfer\EmployeeTransferHistory;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GlobalEmployeeHistory extends Model
{
    // use SoftDeletes;
    protected $table = 'employee_histories';

    const USER = 'usr_id';
    const IS_TEACHER = 'is_teacher';
    const DEPARTMENT = 'department_id';
    const DESIGNATION = 'designation_id';
    const EMPCATEGORY = 'emp_category_id';
    const EMPPOSITION = 'emp_position_id';

    const JOB_TITLE = 'job_title';
    const TRANSPORT_ASSIGN_ID = 'transport_assign_id';
    const EMP_GRADE_ID = 'emp_grade_id';
    const NUMBER_OF_CHILDREN = 'number_of_children';
    const NTRC_REGISTRATION_NUMBER = 'ntrc_registration_number';

    const DEPTJOINDATE = 'dept_join_date';
    const SHIFT = 'shift_id';
    const STATUS ='status';
    const POSITION = 'position';
    const DEPT_JOIN_DATE = 'dept_join_date';



    public $timestamps = false;
    protected $dates = ['deleted_at'];
    protected $appends = array('full_name', 'designation_name','assign_subject_name');

    protected $fillable= [
        self::USER,

        self::JOB_TITLE,
        self::TRANSPORT_ASSIGN_ID,
        self::EMP_GRADE_ID,
        self::NUMBER_OF_CHILDREN,
        self::NTRC_REGISTRATION_NUMBER,
        self::DEPTJOINDATE,

        self::DEPARTMENT,
        self::DESIGNATION,
        self::EMPCATEGORY,
        self::EMPPOSITION,
        self::STATUS,
        self::POSITION,
        self::DEPT_JOIN_DATE,
        self::SHIFT,
        self::CREATED_AT,
        self::UPDATED_AT

    ];


    public $ownFields = [
        self::USER,
        self::IS_TEACHER,

        self::JOB_TITLE,
        self::TRANSPORT_ASSIGN_ID,
        self::EMP_GRADE_ID,
        self::NUMBER_OF_CHILDREN,
        self::NTRC_REGISTRATION_NUMBER,
        self::DEPTJOINDATE,

        self::DEPARTMENT,
        self::DESIGNATION,
        self::EMPCATEGORY,
        self::EMPPOSITION,
        self::STATUS,
        self::POSITION,
        self::DEPT_JOIN_DATE,
        self::SHIFT,
        self::CREATED_AT,
        self::UPDATED_AT
    ];


    public function user()
    {
        return $this->belongsTo(GlobalEmployee::class);
    }
    public function designation()
    {
        return $this->belongsTo(Designation::class, 'designation_id');
    }

    public function employee()
    {
        return $this->belongsTo(GlobalEmployee::class, 'user_id');
    }
    public function SiteEmployeeAssignDutyHistory()
    {
        return $this->hasMany(SiteEmployeeAssignDutyHistory::class,'employee_history_id','id');
    }
    public function EmployeeTransferHistory()
    {
        return $this->hasMany(EmployeeTransferHistory::class,'user_id','user_id');
    }
    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->employee->first_name ?? '') . ' ' . ($this->employee->last_name ?? '');
    }
    public function getAssignSubjectNameAttribute()
    {
        return $this->attributes['assign_subject_name'] = (AcademicSubject::where('id', $this->employee->employee_academic_subject_id)->first()->subject_name ?? '') ;
    }
    public function getDesignationNameAttribute()
    {
        return $this->attributes['designation_name'] = ($this->designation->name ?? '');
    }

}
