<?php

namespace App\Notifications\Live;

use App\Models\Site\Live\Meeting;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;

class MeetingInvitationSent extends Notification implements ShouldQueue
{
    use Queueable;

    public $tries = 1;

    public $meeting;
    public  $title;
    public  $description;


    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Meeting $meeting,$title, $description)
    {
        $this->meeting = $meeting;
        $this->title = $title;
        $this->description =  $description;

    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
//        return ['database', 'broadcast'];
    }
    /**
     * Get the array representation of the notification.
     *
     * @param  mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'id' => $this->meeting->id,
            'link' => '/get-notification/'.$notifiable->id,//$this->route . '/' . $this->id,//route('site-notice-view',[$this->id]),
            'title' =>  $this->title,// $this->invitation->notice_title,
            'data' => $this->description,
            'image_link' =>'no image',// $this->invitation->notice_document_path,
        ];
    }



/*
    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([

            'id' => $this->meeting->id,
            'link' => '/user/my-invitation',//$this->route . '/' . $this->id,//route('site-notice-view',[$this->id]),
            'title' =>  $this->title,// $this->invitation->notice_title,
            'data' =>  $this->description,
            'image_link' =>'no image',// $this->invitation->notice_document_path,
        ]);
    }*/
}
