<?php

namespace App\Traits\Site\Fee;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Payment\SiteStudentOnlinePaymentDetails;
use App\Models\Site\SiteInfo;
use App\Models\Student\StudentHistory;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\User\GlobalUser;
use App\Traits\SmsFunctionsTrait;
use App\Jobs\Site\PaymentHistoryJob;
use App\Models\Session\AdmissionPaymentSession;
use App\Models\Session\PaymentSession;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteAdmissionFeeGatewaySetting;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\StudentAdmission\GlobalSiteAdmissionPaymentHistory;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionFeeGenerate;
use App\Traits\Site\Payment\PaymentGatewayTrait;
use App\Traits\Site\Payment\StudentSonaliPayTransactionTrait;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use Error;
use Exception;
use Response;
use Session;
use DB;

trait SonaliPayAdmissionFeeTrait
{


    use StudentSonaliPayTransactionTrait, AdmissionFeeTrait;

     function detectMixedLanguage2($text) {
        $containsBangla = preg_match('/[\x{0980}-\x{09FF}]/u', $text);
        $containsEnglish = preg_match('/[a-zA-Z]/', $text);
    
        if ($containsBangla && $containsEnglish) {
            return 'mixed';
        } elseif ($containsBangla) {
            return 'bangla';
        } elseif ($containsEnglish) {
            return 'english';
        }
    
        return 'Unknown';
    }

    public function admissionFeeInfoForSonaliPay($request_data,$borad_approve_student){

        $site_id=$request_data['site_id'];
        $request_amount=$request_data['request_amount'];
        $redirect_path=$request_data['redirect_path'];
        $contact_number= (string) $request_data['contact_number'];
        $request_data['username']=$request_data['reference_id'];

         //==== check bank settings ======
        $generated_sub_head_ids = GlobalSiteStudentAdmissionFeeGenerate::where('site_id',$request_data['site_id'])
            ->where('academic_group_id',$borad_approve_student->academic_group_id)
            ->where('site_student_admission_board_approve_id',$borad_approve_student->id)
            ->where('status',true)
            ->orderBy('academic_fee_sub_head_id')
            ->pluck('academic_fee_sub_head_id')
            ->unique()
            ->filter()
            ->values();

        $bank_settings=GlobalSiteAdmissionFeeGatewaySetting::where('fee_type_key','admission_fee')
            ->where('academic_fee_head_id',1)
            ->whereIn('academic_fee_sub_head_id',$generated_sub_head_ids)
            ->where('status',true)
            ->get();

         foreach($generated_sub_head_ids as $key=>$sub_head_id){
             $fee_sub_head=$bank_settings->where('academic_fee_sub_head_id',$sub_head_id)->first();
             if(!$fee_sub_head){
                 return response()->json(['message'=>'Your setup is not complete. Please contact the administrator','status'=>'410'],410);
             }
         }


        $site_payment_gateway_ids=$bank_settings->pluck('site_payment_gateway_id')->unique()->values();
        $payment_gateway_list = GlobalSitePaymentGateway::where('academic_payment_method_key', 'sonali_pay')
            ->where('site_id',$site_id)
            ->whereIn('id',$site_payment_gateway_ids)
            ->get(); 



         /////==========

         $chdckAdmissionFee = GlobalSiteStudentAdmissionFeeGenerate::where('site_id',$site_id)
            ->where('academic_group_id',$borad_approve_student->academic_group_id)
            ->where('site_student_admission_board_approve_id',$borad_approve_student->id)
            ->where('status',true)
            ->get();

        if(count($chdckAdmissionFee)==0){
            return ['message'=>'Payment not found!','status'=>'410'];
        }
       

        $invoiceNo= (string) $borad_approve_student->invoice_no;
        $created_date= (string) $borad_approve_student->created_date;
        $total_amount= (float) number_format($borad_approve_student->total_admission_fee, 2, '.', '');
        $student_full_name= (string) $borad_approve_student->first_name;
        $contact_number= (string) $contact_number;
        $address= (string) $borad_approve_student->address?$borad_approve_student->address:'';
        $email= (string) $borad_approve_student->email?$borad_approve_student->email:'';
        $student_name_lag=$this->detectMixedLanguage2($student_full_name);

        if(empty($contact_number)){
            return ['Status'=>'410','Message'=>'Sorry! Make sure your contact number!'];
        }
        if($student_name_lag!='english'){
            return ['Status'=>'410','Message'=>'Sorry! Make sure your name is written in English.'];
        }

           // full domain url
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
        $domainName = $_SERVER['HTTP_HOST'];
        $fullDomainUrl = $protocol . $domainName;


        $fee_list=[];
        $total_amount=0;
        foreach($chdckAdmissionFee as $key=>$fee){
            $fee_list[$key]['academic_fee_sub_head']=$fee->academicFeeSubHead?$fee->academicFeeSubHead->name:'';
            $fee_list[$key]['amount']=$fee->amount;
            $total_amount+=$fee->amount;
        }


            $CreditInformations=[];
            $serial_no=1;
            $total_cr_amount=0;
            foreach($payment_gateway_list as $key=>$gateway_set){

                $academic_fee_sub_head_ids=$bank_settings->where('site_payment_gateway_id',$gateway_set->id)->pluck('academic_fee_sub_head_id')->unique()->values();
                
                $credit_amount_sum=$chdckAdmissionFee->whereIn('academic_fee_sub_head_id',$academic_fee_sub_head_ids)->sum('amount');
             
                $credit_amount =(float) number_format($credit_amount_sum, 2, '.', '');
                $CreditInformations[$key]['SerialNo']=$serial_no;
                $CreditInformations[$key]['CrAccountOrChallanNo']=$gateway_set->partner_number;
                $CreditInformations[$key]['CrAmount']=$credit_amount;
                $CreditInformations[$key]['TranMode']="TRN";
                $CreditInformations[$key]['Onbehalf']=$student_full_name;

                $serial_no++;
                $total_cr_amount+=$credit_amount;
            }

    

        if($request_amount!=$total_cr_amount){
            return ['Status'=>'410','Message'=>'Credit amount not match!'];
        }

         $trans_data = [
            "InvoiceNo" => $invoiceNo,
            "InvoiceDate" => $created_date,
            "RequestTotalAmount" => $total_amount,
            "CustomerName" => $student_full_name,
            "CustomerContactNo" => $contact_number,
            "CustomerAddress" => '',
            "Email" => '',
            "ResponseUrl" => $fullDomainUrl.$redirect_path,
            "AllowDuplicateInvoiceNoDate" => "N",
            "CreditInformations" => $CreditInformations
        ];

        $res_data=$this->siteStudentSonaliPayTransactionRequest('site-admission',$trans_data,$request_data);

     //   dd($trans_data,$request_data);
          
        if(!isset($res_data['Status'])){
             return ['Status'=>'410','Message'=>$res_data['Message']];
        }

         if($res_data['Status']==='200'){

             //session store
          
             $session=new AdmissionPaymentSession();
             $session->site_student_admission_board_approve_id=$borad_approve_student->id;
             $session->start_date_time=Carbon::now('Asia/Dhaka');
             $session->end_date_time=Carbon::now('Asia/Dhaka')->addMinutes(11);
             $session->gateway_key='SonaliPay';
             $session->token=$res_data['Token'];
             $session->ip_address=request()->ip();
             $session->status=1;
             $session->site_id=$site_id;
             $session->save();
             //=====

             GlobalSiteStudentAdmissionBoardApprove::where('id',$borad_approve_student->id)
                 ->update([
                     'transaction_token'=>$res_data['Token'],
                     'contact_number'=>$contact_number,
                 ]);

             return $res_data;
         }else{

             $issue = new IssueDetail();
             $issue->issue_type='online-transaction-error:site-admission';
             $issue->issuer_type='site';
             $issue->issue_details=$res_data['Message'];
             $issue->site_id=$site_id;
             $issue->username=$borad_approve_student->id;
             $issue->ip_address=request()->ip();
             $issue->save();

             return ['Status'=>'410','Message'=>$res_data['Message']];
         }

     
    }



    public function admissionPaymentAndSonaliPayTokenVerify($data,$req_data){
        

        $site_id=$req_data['site_id'];
        //    $academic_group_id=$req_data['academic_group_id'];
        $username=$req_data['username'];
        $user_id=$req_data['user_id'];
        Session::put('SITE_ID',$site_id);

    

        $borad_approve_student=GlobalSiteStudentAdmissionBoardApprove::where('site_id',$site_id)
            ->where('transaction_token',$data['Token'])
            ->orderBy('id', 'desc')
            ->where('status',1)
            ->first();

        //  dd($demand_slip_details);
            
            if(!$borad_approve_student){

                $request_text=json_encode($data);

                $res_data= [
                    'Status'=>'408',
                    'Message'=>'Mode Succcess, Token is not match',
                    'Details'=>$request_text
                ];

                $response_test=json_encode($res_data);

                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-admission';
                $issue->issuer_type='site';
                $issue->issue_details=$response_test;
                $issue->site_id=$req_data['site_id'];
                $issue->username=$req_data['username'];
                $issue->ip_address=request()->ip();
                $issue->save();

                return $res_data;
            }

            $academic_group_id=$borad_approve_student->academic_group_id;

            $token = (string) $borad_approve_student->transaction_token;

            $req_data=[
                'Token'=>$token,
                'site_id'=>$site_id,
                'username'=>$username,
            ];


            $api_response=$this->verifyTransectionSonaliPayToken('site-admission',$req_data);

            //  dd($api_response);
        
            if($api_response['Status']!='200'){
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-admission';
                $issue->issuer_type='site';
                $issue->issue_details=$api_response['Message'];
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();

                return $api_response;
            }

            
            $slip_no = $borad_approve_student->invoice_no;

        
            if($api_response['InvoiceNo']==$slip_no && $api_response['Token']===$token && $api_response['Status']==='200'){
                
                $res_data=[
                    'site_id'=>$site_id,
                    'academic_group_id'=>$academic_group_id,
                    'username'=>$username,
                    'user_id'=>$user_id,
                    'voucher_no'=>$api_response['InvoiceNo'],
                    'token'=>$api_response['Token'],
                    'status'=>$api_response['Status'],
                    'paid_amount'=>$api_response['RequestTotalAmount'],
                    'transaction_date'=>$api_response['TransactionDate'],
                    'transaction_amount'=>$api_response['CustomerPaidAmount'],
                    'transaction_id'=>$api_response['TransactionId'],
                    'pay_mode'=>$api_response['PayMode'],
                    'paid_by'=>'SonaliPay',
                    'bank_name'=>'SBL',
                ];

             

                //// account setting info

                $generated_sub_head_ids = GlobalSiteStudentAdmissionFeeGenerate::where('site_id',$site_id)
                    ->where('academic_group_id',$borad_approve_student->academic_group_id)
                    ->where('site_student_admission_board_approve_id',$borad_approve_student->id)
                    ->where('status',true)
                    ->orderBy('academic_fee_sub_head_id')
                    ->pluck('academic_fee_sub_head_id')
                    ->unique()
                    ->filter()
                    ->values();

                $bank_settings=GlobalSiteAdmissionFeeGatewaySetting::where('fee_type_key','admission_fee')
                    ->where('academic_fee_head_id',1)
                    ->whereIn('academic_fee_sub_head_id',$generated_sub_head_ids)
                    ->where('status',true)
                    ->get();

                $chdckAdmissionFee = GlobalSiteStudentAdmissionFeeGenerate::with(['academicFeeSubHead'=>function($q){
                        $q->select('id','name');
                    }])
                    ->where('site_id',$site_id)
                    ->where('academic_group_id',$borad_approve_student->academic_group_id)
                    ->where('site_student_admission_board_approve_id',$borad_approve_student->id)
                    ->where('status',true)
                    ->select('id','site_student_admission_board_approve_id','academic_fee_sub_head_id','site_id','academic_group_id','amount')
                    ->get();


                $site_payment_gateway_ids=$bank_settings->pluck('site_payment_gateway_id')->unique()->values();
                $payment_gateway_list = GlobalSitePaymentGateway::where('academic_payment_method_key', 'sonali_pay')
                    ->where('site_id',$site_id)
                    ->whereIn('id',$site_payment_gateway_ids)
                    ->select('id','site_id','partner_number','partner_code','branch_name','app_key','authorization','create_url')
                    ->get();

                $credit_info=[];
                foreach($payment_gateway_list as $key=>$gateway_set){

                    $academic_fee_sub_head_ids=$bank_settings->where('site_payment_gateway_id',$gateway_set->id)->pluck('academic_fee_sub_head_id')->unique()->values();
                    
                    $credit_array=$chdckAdmissionFee->whereIn('academic_fee_sub_head_id',$academic_fee_sub_head_ids)->values();
                    $credit_amount_sum=$credit_array->sum('amount');
                
                    $credit_amount =(float) number_format($credit_amount_sum, 2, '.', '');
                    $credit_info[$key]['credit_details']=$credit_array;
                    $credit_info[$key]['account_no']=$gateway_set->partner_number;
                    $credit_info[$key]['amount']=$credit_amount;
                }

                $res_data['credit_info']=json_encode($credit_info);
                $res_data['account_setting_info']=json_encode($payment_gateway_list);

                ////



                // first update in slip
               // $borad_approve_student->transaction_id=$api_response['TransactionId'];
              //  $borad_approve_student->save();

                $receive_res=$this->gatewayAdmissionPaymentReceive($res_data,$api_response,$borad_approve_student,'sonali_pay');

                if($receive_res['status']=='200'){
                    $issue = new IssueDetail();
                    $issue->issue_type='online-transaction-success:site-admission';
                    $issue->issuer_type='site';
                    $issue->issue_details='payment receive successfully!';
                    $issue->site_id=$site_id;
                    $issue->username=$username;
                    $issue->ip_address=request()->ip();
                    $issue->save();
                }else{
                    $issue = new IssueDetail();
                    $issue->issue_type='online-transaction-receive-error:site-admission';
                    $issue->issuer_type='site';
                    $issue->issue_details=$receive_res['message'];
                    $issue->site_id=$site_id;
                    $issue->username=$username;
                    $issue->ip_address=request()->ip();
                    $issue->save();
                }

                return $api_response;

            }else{
                $response_text=json_encode($api_response);

                $res_data= [
                    'Status'=>'409',
                    'Details'=>'Invoice, Token or Status not match',
                    'Message'=>$response_text
                ];

                $res_text=json_encode($res_data);

                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-admission';
                $issue->issuer_type='site';
                $issue->issue_details=$res_text;
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();


                return $res_data;
            }
    
              
    
    }


    public function updateSoanliAdmissionPayment($data){

        $admissionCandidate=GlobalSiteStudentAdmissionBoardApprove:://where('transaction_token',$data['Token'])
                where('created_date',$data['InvoiceDate'])
                ->where('invoice_no', $data['InvoiceNo'])
                ->first();
               
        if(!$admissionCandidate){
            return ['message'=>'Information not match!', 'status'=>'410'];
        }

        $site_id=$admissionCandidate->site_id;
        $academic_group_id=$admissionCandidate->academic_group_id;
        $user_id=$admissionCandidate->id;
        $username=$admissionCandidate->id;
        $token=$data['Token'];

        $check_payment = GlobalSiteAdmissionPaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('site_student_admission_board_approve_id', $admissionCandidate->id)
            ->where('transaction_id', $data['TransactionId'])
            ->where('invoice_id', $data['InvoiceNo'])
            ->first();

          
        if($check_payment){
            return ['status'=>'200','message'=>'success'];
        }

      
    
        $req_data=[
            'Token'=>$data['Token'],
            'site_id'=>$site_id,
            'academic_group_id'=>$academic_group_id,
            'username'=>$username,
        ];

        $fee_type_key='site-admission';


        $api_response=$this->verifyTransectionSonaliPayToken($fee_type_key,$req_data);

        if($api_response['Status']!='200'){
            $issue = new IssueDetail();
            $issue->issue_type='online-transaction-failed:'.$fee_type_key;
            $issue->issuer_type='site';
            $issue->issue_details=$api_response['Message'];
            $issue->site_id=$site_id;
            $issue->username=$username;
            $issue->ip_address=request()->ip();
            $issue->save();

            return ['message'=>'API error!', 'status'=>'410'];
            
        }

  
        if($api_response['InvoiceNo']==$data['InvoiceNo'] && $api_response['TransactionId']===$data['TransactionId'] && $api_response['Token']===$token && $api_response['Status']==='200'){
          
            $res_data=[
                'site_id'=>$site_id,
                'academic_group_id'=>$academic_group_id,
                'username'=>$username,
                'user_id'=>$user_id,
                'voucher_no'=>$api_response['InvoiceNo'],
                'token'=>$api_response['Token'],
                'status'=>$api_response['Status'],
                'paid_amount'=>$api_response['RequestTotalAmount'],
                'transaction_date'=>$api_response['TransactionDate'],
                'transaction_amount'=>$api_response['CustomerPaidAmount'],
                'transaction_id'=>$api_response['TransactionId'],
                'pay_mode'=>$api_response['PayMode'],
                'paid_by'=>'SonaliPay',
                'bank_name'=>'SBL',
            ];
          
              //// account setting info

        $generated_sub_head_ids = GlobalSiteStudentAdmissionFeeGenerate::where('site_id',$site_id)
              ->where('academic_group_id',$admissionCandidate->academic_group_id)
              ->where('site_student_admission_board_approve_id',$admissionCandidate->id)
              ->where('status',true)
              ->orderBy('academic_fee_sub_head_id')
              ->pluck('academic_fee_sub_head_id')
              ->unique()
              ->filter()
              ->values();

          $bank_settings=GlobalSiteAdmissionFeeGatewaySetting::where('fee_type_key','admission_fee')
              ->where('academic_fee_head_id',1)
              ->whereIn('academic_fee_sub_head_id',$generated_sub_head_ids)
              ->where('status',true)
              ->get();

          $chdckAdmissionFee = GlobalSiteStudentAdmissionFeeGenerate::where('site_id',$site_id)
              ->where('academic_group_id',$admissionCandidate->academic_group_id)
              ->where('site_student_admission_board_approve_id',$admissionCandidate->id)
              ->where('status',true)
              ->get();


          $site_payment_gateway_ids=$bank_settings->pluck('site_payment_gateway_id')->unique()->values();
          $payment_gateway_list = GlobalSitePaymentGateway::where('academic_payment_method_key', 'sonali_pay')
              ->where('site_id',$site_id)
              ->whereIn('id',$site_payment_gateway_ids)
              ->select('id','site_id','partner_number','partner_code','branch_name','app_key','authorization','create_url')
              ->get();

          $credit_info=[];
          foreach($payment_gateway_list as $key=>$gateway_set){

              $academic_fee_sub_head_ids=$bank_settings->where('site_payment_gateway_id',$gateway_set->id)->pluck('academic_fee_sub_head_id')->unique()->values();
              
              $credit_amount_sum=$chdckAdmissionFee->whereIn('academic_fee_sub_head_id',$academic_fee_sub_head_ids)->sum('amount');
          
              $credit_amount =(float) number_format($credit_amount_sum, 2, '.', '');
              $credit_info[$key]['account_no']=$gateway_set->partner_number;
              $credit_info[$key]['amount']=$credit_amount;
          }
        

          $res_data['credit_info']=json_encode($credit_info);
          $res_data['account_setting_info']=json_encode($payment_gateway_list);

         

       //   dd($res_data);

            
            $receive_res=$this->gatewayAdmissionPaymentReceive($res_data,$api_response,$admissionCandidate,'sonali_pay');

            if($receive_res['status']=='200'){
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-success:'.$fee_type_key;
                $issue->issuer_type='site';
                $issue->issue_details='payment receive successfully!';
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();

                //  return ['message'=>'success', 'status'=>'200'];

            }else{
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-receive-error:'.$fee_type_key;
                $issue->issuer_type='site';
                $issue->issue_details=$receive_res['message'];
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();

            }
            return $receive_res;


        }else{

            $issue = new IssueDetail();
            $issue->issue_type='online-transaction-failed:'.$fee_type_key;
            $issue->issuer_type='site';
            $issue->issue_details='Invoice, Token or Status not match';
            $issue->site_id=$site_id;
            $issue->username=$username;
            $issue->ip_address=request()->ip();
            $issue->save();
            return ['message'=>'Information not match!', 'status'=>'410'];
        }


    }


    
}
