<?php

namespace App\Traits\Site;

use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Response;

trait GlobalFunctionsTrait
{
    public function reportTitle($data)
    {

        $report_tittle = "<b>Year: </b>" . ($data->academicYear->year_name ?? '');
        $report_tittle .= " <b>Shift: </b>" . ($data->academicShift->shift_name ?? '');
        $report_tittle .= "  <b> Period Type: </b>" . ($data->academicPeriodType->type_name ?? '');

        $report_tittle .= "<br>";
        if ($data->dept) {
            $report_tittle .= "<b> Dept: </b>" . $data->dept->name;
        }

        if ($data->academicClass) {
            $report_tittle .= "  <b> Class: </b>" . ($data->academicClass->class_name ?? '');
        }

        if ($data->classGroup) {
            $report_tittle .= "<b> Group: </b>" . ($data->classGroup->group_name ?? '');
        }

        if ($data->academicSection) {
            $report_tittle .= "<b> Section: </b>" . ($data->academicSection->section_name ?? '');
        }

        if ($data->academicSession) {
            $report_tittle .= "<b> Session: </b>" . ($data->academicSession->session_name ?? '');
        }

        return $report_tittle;
    }

    public function studentSelectedSubject($student_his)
    {

        $site_id = $student_his->site_id;


        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
            ->pluck('id');


        $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $student_his->academic_class_id)
            ->where('academic_year_id', $student_his->academic_year_id)
            ->where('site_id', $site_id)
            ->where('academic_group_id', $student_his->academic_group_id)
            ->when(!empty($student_list['academic_department_id']), function ($query) use ($student_his) {
                return $query->where('academic_department_id', $student_his['academic_department_id']);
            })
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->where('status', true)
            ->orderBy('subject_position')
            ->get();


        //====Geleral Subject

        $general_subject_ids = [];
        $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

        foreach ($subjectList as $key => $value) {
            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $general_subject_list = $subjectList->whereIn('academic_subject_id', $general_subject_ids)
            ->values();

        //====Compulsory Subject
        $subjectCompulsoryCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

        $compulsory_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            if (in_array($subjectCompulsoryCondition->id, $academicCompulsorySubjectConditionIds)) {
                $compulsory_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $student_selective_compulsory_subject_ids = $student_list->compulsory_subject_ids[1] ?? [];


        if (count($student_selective_compulsory_subject_ids) > 0) {
            $compulsory_subject_final_ids = collect(array_merge($compulsory_subject_ids,
                $student_selective_compulsory_subject_ids))->unique();
        } else {
            $compulsory_subject_final_ids = $compulsory_subject_ids;
        }


        $compulsory_subject_list = $subjectList->whereIn('academic_subject_id', $compulsory_subject_final_ids)
            ->values();


        //====Optional Subject

        $optional_subject_ids = [];
        $subjectOptionalCondition = SubjectCondition::where('condition_key', 'optional')->first();

        foreach ($subjectList as $key => $value) {

            $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);


            if (in_array($subjectOptionalCondition->id, $academicOptionalSubjectConditionIds)) {
                $optional_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $student_selective_optional_subject_ids = ($student_his->optional_subject_ids)[1];


        $optional_subject_list = $subjectList->whereIn('academic_subject_id', $student_selective_optional_subject_ids)
            ->whereIn('academic_subject_id', $optional_subject_ids)
            ->values();


        return [$general_subject_list, $compulsory_subject_list, $optional_subject_list];


    }

    public function studentSubjectIds($student_his)
    {


        // dd($student_his->site_id);

        $site_id = $student_his->site_id;


        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
            ->pluck('id');


        $subjectList = GlobalSubjectGroupConditionSetting::where('academic_class_id', $student_his->academic_class_id)
            ->where('academic_year_id', $student_his->academic_year_id)
            ->where('site_id', $site_id)
            ->where('academic_group_id', $student_his->academic_group_id)
            ->when(!empty($student_his->academic_department_id), function ($query) use ($student_his) {
                return $query->where('academic_department_id', $student_his->academic_department_id);
            })
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->where('status', true)
            ->orderBy('subject_position')
            ->get();

        //====Religion Subject
        $religion_subject_list = $subjectList->where('academic_subject_id', $student_his->religion_subject_id)
            ->values();



      //====General Subject
        $general_subject_ids = [];
        $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

        foreach ($subjectList as $key => $value) {
            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }




        $general_subject_list = $subjectList->whereIn('academic_subject_id', $general_subject_ids)
            ->values();

        //====Compulsory Subject
        $subjectCompulsoryCondition = SubjectCondition::where('condition_key', 'compulsory')->first();
        $compulsory_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            if (in_array($subjectCompulsoryCondition->id, $academicCompulsorySubjectConditionIds)) {
                $compulsory_subject_ids[$key] = $value->academic_subject_id;
            }
        }




        $student_selective_compulsory_subject_ids = $student_his->compulsory_subject_ids[1] ?? [];
        if (count($student_selective_compulsory_subject_ids) > 0) {
            $compulsory_subject_final_ids = collect(array_merge($compulsory_subject_ids,
                $student_selective_compulsory_subject_ids))->unique();
        } else {
            $compulsory_subject_final_ids = $compulsory_subject_ids;
        }
        $compulsory_subject_list = $subjectList->whereIn('academic_subject_id', $compulsory_subject_final_ids)
            ->values();




        //====Optional Subject
        $optional_subject_ids = [];
        $subjectOptionalCondition = SubjectCondition::where('condition_key', 'optional')->first();

        foreach ($subjectList as $key => $value) {
            $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            if (in_array($subjectOptionalCondition->id, $academicOptionalSubjectConditionIds)) {
                $optional_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $student_selective_optional_subject_ids = ($student_his->optional_subject_ids)[1];
        $optional_subject_list = $subjectList->whereIn('academic_subject_id', $student_selective_optional_subject_ids)
            ->whereIn('academic_subject_id', $optional_subject_ids)
            ->values();


        $gen = $general_subject_list->pluck('academic_subject_id')->toArray();
        $rel = $religion_subject_list->pluck('academic_subject_id')->toArray();
        $com = $compulsory_subject_list->pluck('academic_subject_id')->toArray();
        $opt = $optional_subject_list->pluck('academic_subject_id')->toArray();

        $gen_com = array_merge($gen, $rel);
        $rel_com = array_merge($gen_com, $com);
        $final_ids = array_merge($rel_com, $opt);




        return $final_ids;
    }

    public function getClassSubjects($request)
    {


        $year_id = $request->academic_year_id == 'null' ? 0 : $request->academic_year_id;
        $department_id = $request->academic_department_id == 'null' ? 0 : $request->academic_department_id;
        $class_id = $request->academic_class_id == 'null' ? 0 : $request->academic_class_id;
        $class_exam_condition_keys = $request->class_exam_condition_keys ?? ['onlyforclass', 'forclassandexam'];

        if (!$class_id || !$year_id) {
            return Response::json(['message' => 'Select * Marked Field!'], 410);
        }

        $sub_gr_cond_sett = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])
            ->where('academic_class_id', $class_id)
            ->where('academic_year_id', $year_id)
            ->whereHas('academicSubjectClassExamCondition', function ($q) use ($class_exam_condition_keys) {
                $q->whereIn('name_key', $class_exam_condition_keys);
            })
            ->when($department_id, function ($query) use ($department_id) {
                return $query->where('academic_department_id', $department_id);
            })->get();

        // dd($sub_gr_cond_sett);


        $subject_id_array = $sub_gr_cond_sett->pluck('academic_subject_id');
        $subjects = (new AcademicSubject())
            ->whereIn('academic_subjects.id', $subject_id_array)
            ->orderByTranslation('subject_name', 'ASC')
            ->get();

        return $subjects;

    }

}