<?php

namespace App\Traits\SiteGroup\Leave\Employee;

use App\Models\Site\EmployeeLeave\GlobalSiteEmployeeLeaveHistory;
use App\Models\User\GlobalEmployeeHistory;
use Carbon\CarbonPeriod;

trait GlobalLeaveFunction
{
    private function getEmployeeMonthWiseInLeave($employeeID, $search_date)
    {
        $employee_history = GlobalEmployeeHistory::where('user_id', $employeeID)
            ->where('status', 1)
            ->orderBy('id', 'DESC')
            ->first();

        if ($employee_history === null) {
            return false; // No employee history found
        }


        $leave_history = GlobalSiteEmployeeLeaveHistory::where('employee_history_id', $employee_history->id)
            ->where('status', 1)
            ->where('leave_status', 'approved')
            ->get();

        if ($leave_history->isEmpty()) {
            return false; // No leave history found
        }

        if (count($leave_history)) {

            foreach ($leave_history as $key => $value) {
                $start_date = $value->from_date;
                $end_date = $value->to_date;

                $period = CarbonPeriod::create($start_date, $end_date);
                foreach ($period as $date) {
                    $dd = $date->format('m-Y');
                    if ($dd == $search_date) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
    private function getTotalLeaveByMonth($date, $employee)
    {
        $emp_ids = $employee->pluck('id');

        $emp_history_ids = GlobalEmployeeHistory::whereIn('user_id', $emp_ids)->pluck('id');

        $emp_leave_details = GlobalSiteEmployeeLeaveHistory::whereIn('employee_history_id', $emp_history_ids)->where('leave_status', 'approved')->get();
        $leave_days = 0;
        if (count($emp_leave_details)) {

            foreach ($emp_leave_details as $key => $value) {
                $start_date = $value->from_date;
                $end_date = $value->to_date;

                $period = CarbonPeriod::create($start_date, $end_date);
                foreach ($period as $apply_date) {
                    $dd = $apply_date->format('m-Y');
                    if ($dd == $date) {
                        $leave_days += 1;
                    }
                }

            }

        }
        return $leave_days;

    }
    private function getEmployeeInLeave($employeeID, $search_date)
    {
        $employee_history = GlobalEmployeeHistory::where('user_id', $employeeID)
            ->where('status', 1)
            ->orderBy('id', 'DESC')
            ->first();

        if ($employee_history === null) {
            return false; // No employee history found
        }


        $leave_history = GlobalSiteEmployeeLeaveHistory::where('employee_history_id', $employee_history->id)
            ->where('status', 1)
            ->where('leave_status', 'approved')
            ->get();

        if ($leave_history->isEmpty()) {
            return false; // No leave history found
        }

        if (count($leave_history)) {

            foreach ($leave_history as $key => $value) {
                $start_date = $value->from_date;
                $end_date = $value->to_date;

                $period = CarbonPeriod::create($start_date, $end_date);
                foreach ($period as $date) {
                    $dd = $date->format('Y-m-d');
                    if ($dd == $search_date) {

                        return true;
                    }
                }
            }
            return false;
        }
    }
}
