<?php

namespace App\Traits;

use App\Jobs\SendAttSmsJob;
use App\Jobs\SendSmsDynamicJob;
use App\Jobs\Site\StudentAbsentSmsJob;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Edu\SMS\SmsFollowUp;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteMembership;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use Error;
use Session;
use SimpleXMLElement;

trait SmsFunctionsTrait
{
    public function getActiveSmsApi()
    {
        return 'smsinbd';
    }

    public function getSmsRelatedSiteMembershipData($type_id, $type = 'site')
    {

        $site_membership = SiteMembership::where('site_id', $type_id)->where('status', 1)->first();

      

        $sms_balance = $site_membership->sms_balance ?? 0;
        $per_sms_cost = $site_membership->per_sms_cost ?? 0.00;
        $sms_bearer = $site_membership->sms_bearer ?? 0;
        $sms_bearer_id = $site_membership->sms_bearer_id ?? 0;
        $sms_send_type = $site_membership->sms_send_type ?? 'non_masking';
        $sms_send_company = $site_membership->sms_send_company ?? null;

        if ($per_sms_cost <= 0 || !$sms_bearer || !$sms_bearer_id) {
            throw new Error('Sms Cost Or Bearer Or Bearer Id Setting Not Found!');
        }
        return [$sms_balance, $per_sms_cost, $sms_bearer, $sms_bearer_id, $sms_send_type, $sms_send_company];
    }

    public function getSmsBalanceForSite($sms_bearer, $sms_bearer_id)
    {
        $sms_balance = 0;

            $site_membership = SiteMembership::where('site_id', $sms_bearer_id)
                ->where('status', 1)
                ->first();
            $sms_balance = $site_membership->sms_balance ?? 0;

        return $sms_balance;
    }


    public function cutSmsBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id)
    {

            SiteMembership::where('site_id', $sms_bearer_id)
                ->where('status', 1)
                ->decrement('sms_balance', $edu_charged_from_client);

        return $edu_charged_from_client;
    }

    public function returnSmsCutBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id)
    {


            SiteMembership::
            where('site_id', $sms_bearer_id)
                ->where('status', 1)
                ->increment('sms_balance', $edu_charged_from_client);


        return $edu_charged_from_client;
    }


    public function sendEduSmsUsingQueue($number_array, $sms_txt, $sms_company, $sms_masking)
    {


        $type_id = 111;
        $type = 'edu';
        $correct_numbers_array = $this->checkNumbersCorrect($number_array);
        $sms_count = $this->checkSmsCount($sms_txt);
        $sms_type = $this->checkSmsType($sms_txt);//unicode or text
        $total_numbers = count($correct_numbers_array);
//        $sms_mem_data = $this->getSmsRelatedSiteMembershipData($type_id, $type);
        $per_sms_cost = $sms_masking ? 0.40 : 0.15;

        $sms_send_type = $sms_masking ? 'Edu world' : null;
        $sms_send_company = $sms_company;

        $sms_balance_needed = ($sms_count * 0.15 * $total_numbers);


        $sms_data = [];
        $sms_data['sms_txt'] = $sms_txt;
        $sms_data['sms_bearer'] = $type;
        $sms_data['sms_bearer_id'] = $type_id;
        $sms_data['sms_company'] = $sms_send_company;
        $sms_data['per_sms_cost'] = $per_sms_cost;
        $sms_data['sms_count'] = $sms_count;
        $sms_data['total_sms_charges'] = $sms_balance_needed;
        $sms_data['sms_type'] = $sms_type;
        $sms_data['sms_masking'] = $sms_send_type == 'non_masking' ? null : $sms_send_type;

        dispatch(new SendSmsDynamicJob($correct_numbers_array, $sms_data));

        return 'Total Numbers:' . $total_numbers . ' Sms Count:' . $sms_count . ' Sms Cost:' . .15;


    }


    public function sendSmsUsingQueue($number_array, $sms_txt, $type = 'site', $type_id = null)
    {
        // first check the site has sms remaining balance

        $type_id = $type_id ??  Session::get('SITE_ID');
      //  $type_id = $type_id ?? $type_id;

    

        $correct_numbers_array = $this->checkNumbersCorrect($number_array);
        $sms_count = $this->checkSmsCount($sms_txt);
        $sms_type = $this->checkSmsType($sms_txt);//unicode or text
        $total_numbers = count($correct_numbers_array);
        $sms_mem_data = $this->getSmsRelatedSiteMembershipData($type_id, $type);
        $per_sms_cost = $sms_mem_data[1];
        $sms_bearer = $sms_mem_data[2];
        $sms_bearer_id = $sms_mem_data[3];
        $sms_send_type = $sms_mem_data[4];
        $sms_send_company = $sms_mem_data[5];

      

            if (!$sms_count) {
                throw new Error('No Sms Count Found!');
            }


            $sms_balance_needed = ($sms_count * $per_sms_cost * $total_numbers);

            $sms_balance = $this->getSmsBalanceForSite($sms_bearer, $sms_bearer_id);

            if ($sms_balance < $sms_balance_needed) {
                throw new Error('Total Numbers:' . $total_numbers . ' Sms Count:' . $sms_count . ' Sms Cost:' . $sms_balance_needed . ' Balance: ' . $sms_balance);
            }


            $sms_data = [];
            $sms_data['sms_txt'] = $sms_txt;
            $sms_data['sms_bearer'] = $sms_bearer;
            $sms_data['sms_bearer_id'] = $sms_bearer_id;
            $sms_data['sms_company'] = $sms_send_company;
            $sms_data['per_sms_cost'] = $per_sms_cost;
            $sms_data['sms_count'] = $sms_count;
            $sms_data['total_sms_charges'] = $sms_balance_needed;
            $sms_data['sms_type'] = $sms_type;
            $sms_data['sms_masking'] = $sms_send_type == 'non_masking' ? null : $sms_send_type;

            $cut_amount = $this->cutSmsBalance($sms_data['total_sms_charges'], $sms_data['sms_bearer'], $sms_data['sms_bearer_id']);
          //  dd($cut_amount);
            //     dd($sms_data['total_sms_charges'], $sms_data['sms_bearer'], $sms_data['sms_bearer_id']);

            dispatch(new SendSmsDynamicJob($correct_numbers_array, $sms_data));

            return 'Total Numbers:' . $total_numbers . ' Sms Count:' . $sms_count . ' Sms Cost:' . $cut_amount;


    }


    public function checkSmsCount($txt)//type means english or unicode
    {

        if (!$txt) {
            // throw new Error('Sms Text Or Type Not Found!');
            return 0;
        }
        $message_text = str_replace("[nl]", "  ", $txt);
        //  $message_text = str_replace("[nl]", "  ", "The Students who didn't still pay the tuition fee  of  Feb. 2021, Please pay within 25 March. 2021.Academy Lab.School");
        //  $message_text = str_replace("[nl]", "  ", "fee of");
        //  $message_text = str_replace("[nl]", "  ", "fee of");

        //  \Log::info(mb_detect_encoding($message_text));
        //\Log::info($message_text);
        //\Log::info(mb_detect_encoding($message_text, 'UTF-8', true));


        if (strlen($message_text) != strlen(utf8_decode($message_text)))//if unicode chang
            //if (mb_detect_encoding($message_text, 'UTF-8', true))//if unicode / UFT8 / bengali
        {
            $length = mb_strlen($message_text);
            $count = ceil($length / 70);

        } else {//english  , ASCII

            $length = mb_strlen($message_text);
            $count = ceil($length / 160);
        }


        return $count;

    }


    public function checkNumbersCorrect($number_array)
    {
        /*foreach ($number_array as $k=>$item){

        }*/


        return $number_array;

    }

    public function checkSmsType($txt)//type means english or unicode
    {

        if (!$txt) {
            return 0;
        }

        if (strlen($txt) != strlen(utf8_decode($txt)))//if unicode chang
        {
            $type = 'unicode';

        } else {//english sms
            $type = 'text';

        }

        return $type;


    }


    public function checkSmsStatus($msg_id, $company)
    {

        // $msg_id=1568121453514607;
        /*
                 +"ServiceClass": SimpleXMLElement {#1719 ▼
            +"MessageId": "1568121453514607"
            +"Status": "1"
            +"StatusText": "Successfully transmitted"
            +"ErrorCode": "0"
            +"ErrorText": SimpleXMLElement {#1724}
            +"SMSCount": "1"
            +"CurrentCredit": "220.83"

        +"ServiceClass": SimpleXMLElement {#1719 ▼
            +"MessageId": "0"
            +"Status": "-1"
            +"StatusText": "Error occurred"
            +"ErrorCode": "1503"
            +"ErrorText": "message_id_not_exist"
            +"SMSCount": "1"
            +"CurrentCredit": "0"
        */

        // dd($msg_id);

        $return = [];
        if ($company == 'mobireach') {

            $api_request = curl_init('https://api.mobireach.com.bd/GetMessageStatus?Username=the_world&Password=Theworld@123?&MessageId=' . $msg_id);
            curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
            curl_setopt($api_request, CURLOPT_POST, false);
            $result = curl_exec($api_request);
            $sms_response = simplexml_load_string($result);


            //  dd($sms_response->ServiceClass);

            $return = $sms_response->ServiceClass;

        } elseif ($company == 'zamanit') {


            $api_request = curl_init('http://isms.zaman-it.com/miscapi/C20001835e78546c953585.10616633/getDLR/' . $msg_id);
            curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
            curl_setopt($api_request, CURLOPT_POST, false);
            $result = curl_exec($api_request);


            //   $xml = simplexml_load_string();


            //  dd($result);


            //  $sms_response = simplexml_load_string($result);

            // $array = json_decode(json_encode((array)$text), TRUE);


            $return = $result;
            // curl_close($ch);



        } elseif ($company == 'rtcom') {

          $checkMess=SmsFollowUp::where('res_msg_id',$msg_id)->first();

          $smsdate=$checkMess->created_at->format('Ymd');



            $url = 'https://api.rtcom.xyz/deliveryreport';

            $data = [
                'acode'     => '30000047',
                'requestID' => $msg_id,
                'smsdate'   => $smsdate,
            ];


            $ch = curl_init($url);
            $jsonData = json_encode($data);

            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Accept: application/json',
            ]);

            $jsonString = curl_exec($ch);
            $res_data = json_decode($jsonString, true); // Set

            if($res_data['response']['code']=='200'){
                $return=$res_data['info'];
            }else{
                $return[]='operation fail';
            }

             curl_close($ch);


        }
        return $return;
    }


    public function sendAttendanceSms($numbers_array, $sms_txt, $site_id, $att_data_for_queue)
    {


        // first check the site has sms remaining balance

        $sms_mem_data = $this->getSmsRelatedSiteMembershipData($site_id);
        $per_sms_cost = $sms_mem_data[1];
        $sms_bearer = $sms_mem_data[2];
        $sms_bearer_id = $sms_mem_data[3];
        $sms_send_type = $sms_mem_data[4];
        $sms_send_company = $sms_mem_data[5];

        $sms_count = $this->checkSmsCount($sms_txt);
        $sms_type = $this->checkSmsType($sms_txt);
        $total_numbers = count($numbers_array);
        $sms_balance_needed = ($sms_count * $per_sms_cost * $total_numbers);

        $sms_balance = $this->getSmsBalanceForSite($sms_bearer, $sms_bearer_id);

        if ($sms_balance <= $sms_balance_needed) {//sms balance short
            return false;
        }

        $sms_data = [];
        $sms_data['sms_txt'] = $sms_txt;
        $sms_data['sms_bearer'] = $sms_bearer;
        $sms_data['sms_bearer_id'] = $sms_bearer_id;
        $sms_data['per_sms_cost'] = $per_sms_cost;
        $sms_data['sms_count'] = $sms_count;
        $sms_data['total_sms_charges'] = $sms_balance_needed;
        $sms_data['sms_type'] = $sms_type;
        $sms_data['sms_company'] = $sms_send_company;
        $sms_data['sms_masking'] = $sms_send_type == 'non_masking' ? null : $sms_send_type;
        $sms_data['att_user_type'] = $att_data_for_queue['att_user_type'];
        $sms_data['att_type'] = $att_data_for_queue['att_type'];
        $sms_data['att_table_id'] = $att_data_for_queue['att_table_id'];

        $cut_amount = $this->cutSmsBalance($sms_data['total_sms_charges'], $sms_data['sms_bearer'], $sms_data['sms_bearer_id']);


        dispatch(new SendAttSmsJob($numbers_array, $sms_data));

        return [$numbers_array, $sms_data];
    }


    private function sendStudentAbsentSmsUsingQueue($numbers_array, $sms_txt, $att_data_for_queue)
    {

       
        // first check the site has sms remaining balance

        $sms_mem_data = $this->getSmsRelatedSiteMembershipData($att_data_for_queue['site_id']);
        $per_sms_cost = $sms_mem_data[1];
        $sms_bearer = $sms_mem_data[2];
        $sms_bearer_id = $sms_mem_data[3];
        $sms_send_type = $sms_mem_data[4];
        $sms_send_company = $sms_mem_data[5];
       
        $sms_count = $this->checkSmsCount($sms_txt);
        $sms_type = $this->checkSmsType($sms_txt);
        $total_numbers = count($numbers_array);
        $sms_balance_needed = ($sms_count * $per_sms_cost * $total_numbers);
       
        $sms_balance = $this->getSmsBalanceForSite($sms_bearer, $sms_bearer_id);
      //  dd($sms_balance);
        if ($sms_balance <= $sms_balance_needed) {//sms balance short
            return 'Insufficient Balance!';
        }
      
        //   return 'Insufficient Balance!  Current:' .$sms_balance .' Needed:'. $sms_balance_needed.'';


        $sms_data = [];
        $sms_data['sms_txt'] = $sms_txt;
        $sms_data['sms_bearer'] = $sms_bearer;
        $sms_data['sms_bearer_id'] = $sms_bearer_id;
        $sms_data['per_sms_cost'] = $per_sms_cost;
        $sms_data['sms_count'] = $sms_count;
        $sms_data['total_sms_charges'] = $sms_balance_needed;
        $sms_data['sms_type'] = $sms_type;
        $sms_data['sms_company'] = $sms_send_company;
        $sms_data['sms_masking'] = $sms_send_type == 'non_masking' ? null : $sms_send_type;
        $sms_data['table_id'] = $att_data_for_queue['table_id'];

        $cut_amount = $this->cutSmsBalance($sms_data['total_sms_charges'], $sms_data['sms_bearer'], $sms_data['sms_bearer_id']);

       
        StudentAbsentSmsJob::dispatch($numbers_array, $sms_data);
       

        return 'Total Numbers:' . $total_numbers . ' Sms Count:' . $sms_count . ' Sms Cost:' . $cut_amount;


    }


}
