<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeSiteStudentFeeWaiverOfferHistories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_fee_waiver_offer_histories', function (Blueprint $table) {
            $table->dropColumn('academic_fee_head_id');
            $table->dropColumn('academic_fee_group_id');
            $table->dropColumn('academic_fee_sub_head_id');
            $table->dropColumn('academic_version_id');
            $table->dropColumn('academic_year_id');
            $table->dropColumn('academic_shift_id');
            $table->dropColumn('academic_department_id');
            $table->dropColumn('academic_class_id');
            $table->dropColumn('academic_class_group_id');
            $table->dropColumn('academic_session_id');
            $table->renameColumn('user_id','student_history_id');
            $table->integer('site_student_fee_fine_allocation_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_fee_waiver_offer_histories', function (Blueprint $table) {
            //
        });
    }
}
