<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteExamDeclareStudentAndExamRoutineTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
//        Schema::dropIfExists('site_exam_declares');
//        Schema::dropIfExists('site_exam_routines');
//        Schema::dropIfExists('site_exam_declare_student');
//        Schema::dropIfExists('site_exam_declare_student_subjects');

        Schema::create('site_exam_declares', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->string('site_subject_group_condition_setting_ids')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });




        Schema::create('site_exam_routines', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id')->nullable();
            $table->integer('site_exam_declare_id')->nullable();
            $table->integer('site_subject_group_condition_setting_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->integer('academic_exam_type_id')->nullable();
            $table->date('exam_start_date')->nullable();
            $table->date('exam_end_date')->nullable();
            $table->time('exam_start_time')->nullable();
            $table->time('exam_end_time')->nullable();
            $table->integer('exam_duration')->nullable();
            $table->integer('per_day_student')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });


        Schema::create('site_exam_declare_students', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_exam_declare_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });

        Schema::create('site_exam_declare_student_subjects', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_exam_declare_id')->nullable();
            $table->integer('site_exam_declare_student_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->integer('academic_exam_type_id')->nullable();
            $table->integer('site_subject_group_condition_setting_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_exam_declare_student_and_exam_routine');
    }
}
