<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSiteRoutineWeekwiseClassNo extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_routine_subject_weekly_classes', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->integer('academic_version_id');
            $table->integer('academic_year_id');
            $table->integer('academic_shift_id');
            $table->integer('academic_department_id')->default(0);
            $table->integer('academic_class_id');


            $table->integer('academic_subject_id');
            $table->tinyInteger('no_of_weekly_class')->default(0);


            $table->integer('academic_group_id');
            $table->integer('site_id');
            $table->boolean('status');





            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_routine_subject_weekly_classes');
    }
}
