<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePeriodicAttendancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_periodic_attendances', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->string('present_type',20)->nullable();
            $table->time('in_time')->nullable();
            $table->time('out_time')->nullable();
            $table->date('present_date')->nullable();
            $table->dateTime('present_date_time')->nullable();
            $table->integer('present_year')->nullable();
            $table->integer('present_month')->nullable();
            $table->integer('present_day')->nullable();
            $table->boolean('late_status')->nullable();
            $table->string('note')->nullable();
            $table->timestamps();
        });
    }



   /* const STUDENT_HISTORY_ID = 'student_history_id';
    const ROUTINE_ALLOCATION_ID = 'routine_allocation_id';
    const SHIFT_DETAILS_ID = 'site_shift_details_id';
    const ROLL_NO = 'roll_no';
    const PRESENT_TYPE = 'present_type';
    const PRESENT_TYPE_ID = 'present_type_id';
    const IN_TIME = 'in_time';
    const OUT_TIME = 'out_time';
    const ATTENDANCE_DATE = 'present_date';
    const ATTENDANCE_DATE_TIME = 'present_date_time';
    const ATTENDANCE_YEAR = 'present_year';
    const ATTENDANCE_MONTH = 'present_month';
    const ATTENDANCE_DAY = 'present_day';
    const OFF_DAY_ATT = 'off_day_att';
    const NOTE = 'note';
    const STUDENT_CLASS = 'student_class';
    const SECTION = 'section';
    const SUBJECT = 'subject';
    const LATE_STATUS = 'late_status';*/

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('periodic_attendances');
    }
}
