<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteBaseStudentRegistrationDeclareTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_base_student_registration_declare', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('remark')->nullable();
            $table->date('duration_from_date')->nullable();
            $table->date('duration_to_date')->nullable();
            $table->date('extended_date')->nullable();

            $table->integer('academic_group_id')->nullable();
            $table->string('academic_version_ids')->nullable();
            $table->string('academic_shift_ids')->nullable();
            $table->string('academic_year_ids')->nullable();
            $table->string('academic_department_ids')->nullable();
            $table->string('academic_class_ids')->nullable();
            $table->string('academic_session_ids')->nullable();
            $table->boolean('send_sms')->default(false);

            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();




        });




        Schema::create('site_student_registration_application', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_student_category_id')->nullable();
            $table->integer('academic_student_type_id')->nullable();
            $table->integer('academic_student_admission_type_id')->nullable();

            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();

            $table->string('academic_subject_ids')->nullable();
            $table->string('optional_subject_ids')->nullable();
            $table->string('selective_markingless_subject_ids')->nullable();
            $table->string('compulsory_subject_ids')->nullable();
            $table->integer('religion_subject_id')->nullable();

            $table->string('board_registration_number')->nullable();
            $table->string('student_roll_number')->nullable();
            $table->integer('registration_no')->nullable();
            $table->integer('academic_residence_id')->nullable();
            $table->integer('academic_transport_id')->nullable();

            $table->integer('academic_quata_id')->nullable();

            $table->integer('previous_academic_class_id')->nullable();
            $table->string('previous_roll_no')->nullable();
            $table->double('previous_gpa')->nullable();
            $table->double('previous_exam_mark')->nullable();
            $table->string('previous_institute_name')->nullable();
            $table->string('previous_institute_location')->nullable();
            $table->string('tc_number')->nullable();
            $table->date('tc_date')->nullable();

            $table->string('email')->nullable();
            $table->string('name_native_language')->nullable();
            $table->string('student_contact_number')->nullable();
            $table->integer('blood_group_id')->nullable();
            $table->string('mother_occupation_id')->nullable();
            $table->double('mother_yearly_income')->nullable();
            $table->string('mother_contact_number')->nullable();
            $table->string('mother_email')->nullable();
            $table->integer('father_occupation_id')->nullable();
            $table->double('father_yearly_income')->nullable();
            $table->string('father_contact_number')->nullable();
            $table->string('father_email')->nullable();

            $table->integer('present_country_id')->nullable();
            $table->integer('present_division_id')->nullable();
            $table->integer('present_district_id')->nullable();
            $table->integer('present_thana_id')->nullable();
            $table->string('present_address')->nullable();
            $table->integer('permanent_country_id')->nullable();
            $table->integer('permanent_division_id')->nullable();
            $table->integer('permanent_district_id')->nullable();
            $table->integer('permanent_thana_id')->nullable();
            $table->string('permanent_address')->nullable();

            $table->string('local_guardian_name')->nullable();
            $table->string('local_gurdian_mobile')->nullable();
            $table->string('local_gurdian_address')->nullable();
            $table->string('local_gurdian_email')->nullable();


            $table->integer('gender_id')->nullable();
            $table->integer('religion_id')->nullable();
            $table->integer('guardian_student_relation_id')->nullable();
            $table->string('emergency_contact')->nullable();
            $table->string('nid_number')->nullable();
            $table->string('passport_no')->nullable();
            $table->string('birth_certificate_no')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('unique_code')->nullable();
            $table->string('student_image')->nullable();

            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_base_student_registration_declare');
    }
}
