<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClassRoonsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('website_class_rooms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('entry_type')->nullable();
            $table->integer('serial_no')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_subject_id')->nullable();
            $table->integer('faculty_id')->nullable();
            $table->date('entry_date')->nullable();
            $table->date('publish_date')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->default(1);
            $table->boolean('pause_status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('website_class_rooms');
    }
}
