<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAccountsFixedAssetsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_accounts_fixed_assets', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('item_name')->nullable();
            $table->string('item_code')->nullable();
            $table->decimal('purchase_cost',9,2)->nullable();
            $table->integer('site_accounts_voucher_detail_id')->nullable();
            $table->date('purchase_date')->nullable();
            $table->boolean('depriciation_status')->nullable();
            $table->string('depriciation_type')->nullable();
            $table->decimal('depriciation_amount',9,2)->nullable();
            $table->integer('life_time')->nullable();
            $table->date('depriciation_active_date')->nullable();
            $table->integer('expense_ledger_id')->nullable();
            $table->string('narration',255)->nullable();
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_accounts_fixed_assets');
    }
}
