<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentAdmissionDeclareOnlineApisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_admission_declare_online_apis', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_admission_declare_id');
            $table->integer('academic_payment_type_id');
            $table->string('academic_payment_type_key');
            $table->integer('payment_company_id');
            $table->string('vendor')->nullable();
            $table->string('username')->nullable();
            $table->string('password')->nullable();
            $table->string('partner_code')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });


        Schema::table('site_student_admission_declares', function (Blueprint $table) {
            $table->boolean('check_with_board_university')->default(false);

        });

        Schema::table('site_student_admission_applications', function (Blueprint $table) {
            $table->date('date_of_birth')->nullable()->change();
            $table->double('transaction_amount')->nullable();
            $table->dateTime('transaction_date')->nullable();

        });



        Schema::table('site_testimonial_settings', function (Blueprint $table) {
            $table->boolean('session_show_status')->default(false);
            $table->boolean('exam_center_show_status')->default(false);
            $table->string('testimonial_background_color')->default('white');
            $table->string('exam_center')->nullable();
            $table->string('exam_center_code')->nullable();



        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_admission_declare_online_apis');
    }
}
