<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddLiveMeetinngsTanble extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_live_meetings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('contact_email')->nullable();
            $table->string('meeting_id')->nullable();
            $table->string('uuid')->nullable();
            $table->string('host_id')->nullable();
            $table->string('topic')->nullable();
            $table->string('start_url',1000)->nullable();
            $table->string('join_url')->nullable();
            $table->text('response')->nullable();
            $table->text('recurrence')->nullable();
            $table->dateTimeTz('start_time');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_live_meetings');
    }
}
