<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentInvoiceDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {


        Schema::create('edu_student_invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->integer('edu_student_invoice_declare_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->double('payable_amount')->nullable();
            $table->double('paid_amount')->nullable();
            $table->boolean('online_payment_status')->default(false);
            $table->boolean('manual_payment_status')->default(false);

            $table->date('payment_from_date')->nullable();
            $table->boolean('payment_to_date')->nullable();
            $table->boolean('edu_student_panel_close_date')->nullable();

            $table->integer('academic_online_payment_method_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });


        Schema::create('edu_student_invoice_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_invoice_id')->nullable();
            $table->integer('edu_item_detail_id')->nullable();
            $table->double('payment_amount')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });



        Schema::dropIfExists('edu_transaction_details');
        Schema::create('edu_transaction_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->double('paid_amount')->nullable();
            $table->integer('academic_online_payment_method_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();

        });


        Schema::dropIfExists('edu_site_transaction_declares');
        Schema::create('edu_student_invoice_declares', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_id');
            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->date('payment_from_date')->nullable();
            $table->date('payment_to_date')->nullable();
            $table->date('edu_student_panel_close_date')->nullable();
            $table->double('payment_amount')->nullable();
            $table->boolean('student_panel_close_status')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });


        Schema::dropIfExists('edu_site_transaction_declare_items');
        Schema::create('edu_student_invoice_declare_items', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('edu_student_invoice_declare_id');
            $table->integer('edu_item_detail_id');
            $table->double('amount')->nullable();
            $table->boolean('status')->nullable();
            $table->integer('site_id');
            $table->timestamps();
        });


        Schema::table('users', function (Blueprint $table) {
            $table->boolean('student_edu_payment_status')->default(true);
            $table->boolean('edu_student_panel_close_date')->nullable();
        });

        Schema::table('student_histories', function (Blueprint $table) {
            $table->boolean('student_edu_payment_status')->default(true);
            $table->boolean('edu_student_panel_close_date')->nullable();
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_invoice_details');
    }
}
