<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSocialIconToSiteInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::table('site_infos', function (Blueprint $table) {
            $table->string('facebook_link')->nullable();
            $table->string('twitter_link')->nullable();
            $table->string('google_link')->nullable();
            $table->string('youtube_link')->nullable();
        });


        Schema::create('site_web_site_visitor_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('ip_address')->nullable();
            $table->integer('site_id')->nullable();
            $table->date('visite_date')->nullable();
            $table->timestamps();
        });


        Schema::table('edu_newsite_applications', function (Blueprint $table) {

            $table->string('existed_domain')->nullable();

        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_infos', function (Blueprint $table) {
            //
        });
    }
}
