<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteQuizzesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_quizzes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('quiz_name');
            $table->text('quiz_note')->nullable();
            $table->string('quiz_key')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('site_group_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_quizzes');
    }
}
