<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupAcademicSettingsStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_academic_settings_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('academic_group_id');
            $table->bigInteger('site_group_id');
            $table->string('academic_year_ids')->nullable();
            $table->string('academic_class_ids')->nullable();
            $table->string('academic_department_ids')->nullable();
            $table->string('academic_class_group_ids')->nullable();
            $table->string('academic_subject_condition_ids')->nullable();
            $table->string('academic_group_ids')->nullable();
            $table->string('academic_subject_ids')->nullable();
            $table->string('academic_session_ids')->nullable();
            $table->string('academic_section_ids')->nullable();
            $table->string('academic_version_ids')->nullable();
            $table->string('academic_student_type_ids')->nullable();
            $table->string('student_category_ids')->nullable();
            $table->string('shift_ids')->nullable();
            $table->string('gender_ids')->nullable();
            $table->string('designation_ids')->nullable();
            $table->string('academic_fee_head_ids')->nullable();
            $table->string('academic_fee_group_ids')->nullable();
            $table->string('academic_fee_sub_head_ids')->nullable();
            $table->string('academic_waiver_type_ids')->nullable();
            $table->string('academic_student_offer_type_ids')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_academic_settings_stores');
    }
}
