<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteClassSubjectAssessmentTopicsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_class_subject_assessment_topics', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->integer('academic_version_id');
            $table->integer('academic_year_id');
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id');
            $table->integer('academic_subject_id');
            $table->string('topic_name');
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_class_subject_assessment_topics');
    }
}
