<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentAssessmentCombineFinalResultDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_assessment_combine_final_result_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_history_id');
            $table->integer('academic_assessment_result_combine_type_id');
            $table->integer('assessment_type_id')->nullable();
            $table->text('result_details')->nullable();
            $table->string('result_type_key')->default('PI');
            $table->integer('student_rank')->nullable();
            $table->boolean('result_employee_publish_status')->default(false);
            $table->boolean('result_student_publish_status')->default(false);
            $table->boolean('result_public_publish_status')->default(false);

            $table->boolean('status')->default(true);
            $table->integer('site_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_assessment_combine_final_result_details');
    }
}
