<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentHeadWiseFeePaymentHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_head_wise_fee_payment_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_fee_generate_id');
            $table->integer('student_history_id');
            $table->integer('site_student_fee_payment_history_id')->nullable();
            $table->decimal('amount',8,2)->nullable();

            $table->decimal('payable_amount',8,2)->nullable();
            $table->decimal('pay_amount',8,2)->nullable();
            $table->decimal('sub_total_pay_amount',8,2)->nullable();

            $table->decimal('due_amount',8,2)->nullable();
            $table->decimal('sub_total_due_amount',8,2)->nullable();
            $table->decimal('waiver_amount',8,2)->nullable();
            $table->decimal('sub_total_waiver_amount',8,2)->nullable();

            $table->boolean('payment_collected_status')->default(false);
            $table->boolean('payment_due_status')->default(false);

            $table->integer('collected_by')->nullable();
            $table->integer('site_id');
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_head_wise_fee_payment_histories');
    }
}
