<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupAnswerPaperDistributionDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_answer_paper_distribution_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('academic_version_id');
            $table->integer('academic_year_id');
            $table->integer('academic_shift_id');
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_subject_id')->nullable();
            $table->integer('site_subject_group_condition_setting_id')->nullable();
            $table->integer('site_group_exam_declare_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->integer('academic_exam_type_id')->nullable();
            $table->integer('token_from');
            $table->integer('token_to');
            $table->integer('marks_input_by')->nullable();
            $table->integer('marks_last_update_by')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('site_group_id');
            $table->integer('user_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_answer_paper_distribution_details');
    }
}
