<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class SiteGroupResultCombineSettingStores extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::create('site_group_result_combine_setting_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_group_id');
            $table->integer('academic_group_id');
            $table->integer('academic_version_id');
            $table->integer('academic_year_id');
            $table->integer('academic_shift_id');
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_result_primary_type_id')->nullable();
            $table->integer('academic_result_combine_type_id')->nullable();
            $table->integer('marks_percentage')->nullable();
            $table->integer('show_position')->nullable();
            $table->boolean('is_average')->default(false);
            $table->boolean('fail_allow')->default(false);
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_result_combine_setting_stores');
    }
}
