<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class SiteGroupResultSystemSettingStores extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //
         
        Schema::create('site_group_result_system_setting_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_group_id');
            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_session_id')->nullable();
            $table->integer('academic_result_system_id');
            $table->double('number_from')->nullable();
            $table->double('number_to')->nullable();
            $table->double('point')->nullable();
            $table->double('point_from')->nullable();
            $table->double('point_to')->nullable();
            $table->boolean('pass_fail_status');
            $table->boolean('status')->default(true);
            $table->timestamps();
        });

      
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
