<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteCertificationSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_certification_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('border_image')->nullable();
            $table->boolean('watermark_status')->default(false);
            $table->string('background_color')->nullable();
            $table->longText('content')->nullable();
            $table->string('watermark_image')->nullable();
            $table->string('initial_referance_prefix', 10)->nullable();
            $table->integer('initial_referance_number')->nullable();
            $table->string('initial_referance_suffix', 10)->nullable();
            $table->integer('site_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_certification_settings');
    }
}
