<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCommentShowStatusToSiteExamResultReportSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_exam_result_report_settings', function (Blueprint $table) {
            $table->boolean('comment_show_status')->default(0)->after('curriculam_activities_show_status');

            $table->boolean('exam_marks_show_status')->default(0)->after('comment_show_status');

            $table->boolean('obtained_marks_show_status')->default(0)->after('exam_marks_show_status');

            $table->boolean('percentage_show_status')->default(0)->after('obtained_marks_show_status');

            $table->boolean('grade_show_status')->default(0)->after('percentage_show_status');

            $table->boolean('class_show_status')->default(0)->after('grade_show_status');

            $table->boolean('section_show_status')->default(0)->after('class_show_status');

            $table->boolean('roll_no_show_status')->default(0)->after('section_show_status');

            $table->boolean('shift_show_status')->default(0)->after('roll_no_show_status');

            $table->boolean('mother_name_show_status')->default(0)->after('shift_show_status');

            $table->boolean('father_name_show_status')->default(0)->after('mother_name_show_status');



            $table->boolean('failed_show_status')->default(0)->after('father_name_show_status');

            $table->boolean('gpa_show_status')->default(0)->after('failed_show_status');

            $table->boolean('group_show_status')->default(0)->after('gpa_show_status');

            $table->boolean('session_show_status')->default(0)->after('group_show_status');

            $table->boolean('bottom_logo_show_status')->default(0)->after('session_show_status');

            $table->string('bottom_logo')->nullable()->after('bottom_logo_show_status');

            $table->string('pdf_type')->default('portrait')->after('bottom_logo');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_exam_result_report_settings', function (Blueprint $table) {
            $table->dropColumn('comment_show_status');
            $table->dropColumn('exam_marks_show_status');
            $table->dropColumn('obtained_marks_show_status');
            $table->dropColumn('percentage_show_status');
            $table->dropColumn('grade_show_status');
            $table->dropColumn('class_show_status');
            $table->dropColumn('section_show_status');
            $table->dropColumn('roll_no_show_status');
            $table->dropColumn('shift_show_status');
            $table->dropColumn('mother_name_show_status');
            $table->dropColumn('father_name_show_status');
            $table->dropColumn('session_show_status');
            $table->dropColumn('group_show_status');
            $table->dropColumn('bottom_logo');
            $table->dropColumn('gpa_show_status');
            $table->dropColumn('failed_show_status');
        });
    }
}
