<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAdmissionPaymentHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_admission_payment_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_admission_board_approve_id');
            $table->string('invoice_id')->nullable();
            $table->string('transaction_id')->nullable();
            $table->string('transaction_token')->nullable();
            $table->string('transaction_date')->nullable();
            $table->string('transaction_time')->nullable();
            $table->double('total_paid_amount')->nullable();
            $table->double('gateway_charge')->nullable();
            $table->double('transaction_amount')->nullable();
            $table->string('transaction_mode')->nullable();
            $table->string('transaction_gateway')->nullable();
            $table->text('transaction_gateway_response')->nullable();
            $table->text('credit_info')->nullable();
            $table->text('account_setting_info')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_admission_payment_histories');
    }
}
