<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLibraryBookHistoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('library_book_history', function (Blueprint $table) {
            $table->increments('id'); // primary key
            $table->string('book_code', 100);
            $table->unsignedInteger('book_id');

            $table->foreign('book_id')
                ->references('id')
                ->on('books')
                ->onDelete('cascade');
            $table->integer('site_id')->nullable();

            $table->string('status')->nullable();
            $table->string('condition')->nullable();
            $table->string('sale_status')->nullable();
            $table->text('damage_info')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('library_book_history');
    }
}
