<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcademicProgressTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academic_progress', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('progress_name');
            $table->text('prorgess_note')->nullable();
            $table->string('name_key')->unique();
            $table->string('use_key')->default('site');
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('academic_progress');
    }
}
