import VueCtkDateTimePicker from "vue-ctk-date-time-picker";
import "vue-ctk-date-time-picker/dist/vue-ctk-date-time-picker.css";
Vue.component("VueCtkDateTimePicker", VueCtkDateTimePicker);

import EmployeeListComponent from "../components/site/employee/EmployeeListComponent.vue";

export default {
    components: {
        EmployeeListComponent
    },
    props: ["getSiteBaseCountryList"],
    data() {
        return {
            ListShow: true,
            formShow: false,
            EmpListBtnShow: false,
            EmpFormBtnShow: true,

            dataloadingImage: false,
            savingImage: false,
            editMode: false,
            //  FixedDataShowHide:true,

            tab: 1,
            view_type: 1,
            id: "",
            site_info_id: "",
            academic_department_id: null,
            departmentList: [],

            form_title: "New Employee",

            // AcademicVersionList:[],
            // academic_version_id:"",

            getGenderList: [],
            ReligionList: [],
            // AcademicSectionList:[],
            // academic_section_id:null,

            // student_history_id:"",
            // studentHistoryList:[],

            // academic_class_group_id:null,
            // AcademicClassGroupList:[],

            // academic_year_id:null,
            // AcademicYearList:[],

            // academic_session_id:null,
            // AcademicSessionList:[],

            // academic_shift_id: null,
            // AcademicShiftList: [],

            // academic_class_id: null,
            // AcademicClassList: [],

            getQuataList: [],

            getResidenceList: [],

            // present address
            PresentCountryList: [],
            PresentDivisionList: [],
            PresentDistrictList: [],
            PresentThanaList: [],

            // Permanent address
            PermanentCountryList: [],
            PermanentDivisionList: [],
            PermanentDistrictList: [],
            PermanentThanaList: [],

            presentDivisionLoadingImg: false,
            presentDistrictLoadingImg: false,
            presentThanaLoadingImg: false,

            permanentDivisionLoadingImg: false,
            permanentDistrictLoadingImg: false,
            permanentThanaLoadingImg: false,

            sameAddressSelect: false,
            GurdianInfoShowHide: false,
            PrimaryInfoShowHide: true,

            getBloodGroupList: [],

            getStudentAdmissionTypeList: [],
            academic_student_admission_type_id: null,

            AddressShowHide: false,
            CommunicationInfoShowHide: false,
            PreviousInfoHideShow: false,
            LocalGurdianHideShow: false,
            whenYearClassSelect: false,
            FundamentalInfoShowHide: true,
            date_of_birth: "",

            student_name_for_edit: null,

            RelationList: [],
            whenEditClick: false,

            PersonalInfoShowHide: false,
            AcademicQualificationShowHide: false,
            getMaritalStatusList: [],
            ExperianceInfoShowHide: false,
            AssignTransportList: [],
            EmployeeGradeList: [],
            DesignationList: [],
            QualificationList: [],
            ExperianceList: [],

            DegreeList: [],
            ResultTypeList: [],

            PrimaryInfoShowHide: false,

            form: new Form({
                id: "",
                user_id: "",
                is_teacher: 1,
                institute_head: 0,

                status: "",
                employee_id: "",
                employee_serial: 0,
                gender_id: null,
                academic_residence_id: null,
                religion_id: null,
                blood_group_id: null,

                present_country_id: null,
                present_division_id: null,
                present_district_id: null,
                present_thana_id: null,
                present_address: "",

                permanent_country_id: null,
                permanent_division_id: null,
                permanent_district_id: null,
                permanent_thana_id: null,
                permanent_address: "",

                first_name: "",
                last_name: "",
                name_native_language: "",
                father_name: "",
                mother_name: "",
                spouse_name: "",
                date_of_birth: "",
                contact_number: "",
                teacher_registration_number: "",
                dept_join_date: "",
                academic_quata_id: null,
                designation_id: null,

                birth_certificate_no: "",
                nid_number: "",
                teacher_mobile_number: "",
                email: "",
                passport_no: "",
                emergency_contact: "",
                number_of_children: "",

                job_title: "",
                emp_grade_id: null,
                transport_assign_id: null,
                marital_status_id: null,
                ntrc_registration_number: "",
                employee_image: "",
                signature: ""
            }),
            ssct: new Form({
                id: "",
                designation_id: null
            })
        };
    },
    methods: {
        EmpListBtnClick() {
            this.ListShow = true;
            this.formShow = false;
            this.EmpFormBtnShow = true;
            this.EmpListBtnShow = false;
        },

        EmpFormBtnClick() {
            this.formShow = true;
            this.ListShow = false;
            this.EmpListBtnShow = true;
            this.EmpFormBtnShow = false;
            this.form.reset();
            this.editMode = false;
            this.form_title = "Add New Employee";

            this.PrimaryInfoShowHide = false;
            this.PersonalInfoShowHide = false;
            this.AcademicQualificationShowHide = false;
            this.AddressShowHide = false;
            this.CommunicationInfoShowHide = false;
            this.ExperianceInfoShowHide = false;
            this.ExperianceList = [];
            this.QualificationList = [];
        },

        qualificationBarClick() {
            this.QualificationList = [
                {
                    examination_id: null,
                    board_university_name: null,
                    passing_year: null,
                    time_duration: null,
                    result_type_id: null
                }
            ];

            if (this.AcademicQualificationShowHide) {
                axios
                    .get("/site/employee/get-employee-examination-list")
                    .then(({ data }) => {
                        console.log(data);

                        this.DegreeList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => {});
            }
        },

        addQualificationRow() {
            this.QualificationList.push({
                examination_id: null,
                board_university_name: null,
                passing_year: null,
                time_duration: null,
                result_type_id: null
            });
        },

        deleteQualificationRow(index) {
            this.QualificationList.splice(index, 1);
        },

        experianceBarClick() {
            this.ExperianceList = [
                {
                    company_name: null,
                    company_location: null,
                    position_held: null,
                    responsibilites: null,
                    from_date: null,
                    to_date: null,
                    currently_working: null
                }
            ];
        },

        addExperianceRow() {
            this.ExperianceList.push({
                company_name: null,
                company_location: null,
                position_held: null,
                responsibilites: null,
                from_date: null,
                to_date: null,
                currently_working: null
            });
        },

        deleteExperianceRow(index) {
            this.ExperianceList.splice(index, 1);
        },

        getDesignationReligionGender() {
            axios
                .get(
                    "/site/employee/get-employee-desigantion-religion-gender-list"
                )
                .then(({ data }) => {
                    console.log(data);
                    this.getGenderList = data[0];
                    this.ReligionList = data[1];
                    this.DesignationList = data[2];
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {});
        },

        primaryInfoBlank() {
            this.getResidenceList = [];
            this.EmployeeGradeList = [];
            this.AssignTransportList = [];
            this.getQuataList = [];
            this.getBloodGroupList = [];

            this.form.name_native_language = "";
            this.form.date_of_birth = "";
            this.form.joining_date = "";
            this.form.job_title = "";
            this.form.nationality = "";
            this.form.teacher_registration_number = "";
            this.form.blood_group_id = null;
            this.form.assing_transport_id = null;
            this.form.academic_residence_id = null;
            this.form.academic_quata_id = null;
            this.form.employee_grade_id = null;
        },

        getResidenceEmpgradeTransportQuataBloodgroupList() {
            this.primaryInfoBlank();

            if (this.PrimaryInfoShowHide) {
                axios
                    .get(
                        "/site/employee/get-residence-empgrade-transport-quata-bloodgroup-list"
                    )
                    .then(({ data }) => {
                        console.log(data);

                        this.getResidenceList = data[0];
                        this.EmployeeGradeList = data[1];
                        this.AssignTransportList = data[2];
                        this.getQuataList = data[3];
                        this.getBloodGroupList = data[4];
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => {});
            }
        },

        browse() {
            document.querySelector("input[type=file]").click();
        },

        employeeImageSelect(event) {
            let file = event.target.files[0];
            //console.log(file);
            let reader = new FileReader();
            let limit = 1024 * 1024 * 2;

            if (file["size"] > limit) {
                swal({
                    type: "error",
                    title: "Oops...",
                    text: "You are uploading a large file"
                });
                return false;
            }

            reader.onloadend = file => {
                this.form.employee_image = reader.result;
                console.log(reader.result);
            };
            reader.readAsDataURL(file);
        },

        getProfilePhoto() {
            let photo = "";
            if (this.form.employee_image) {
                //console.log(this.form.employee_image)
                this.photo =
                    this.form.employee_image.length > 200
                        ? this.form.employee_image
                        : "/uploads/" + this.form.employee_image;
            } else {
                this.photo = "/uploads/image-not.png";
                this.form.employee_image = "image-not.png";
            }
            return this.photo;
        },
        browseSignature() {
            document.querySelector("input[name='employee_sign']").click();
        },
        empSignature(event) {
            let file = event.target.files[0];
            //console.log(file);
            let reader = new FileReader();
            let limit = 1024 * 1024 * 2;

            if (file["size"] > limit) {
                swal({
                    type: "error",
                    title: "Oops...",
                    text: "You are uploading a large file"
                });
                return false;
            }

            reader.onloadend = file => {
                this.form.signature = reader.result;
                console.log(reader.result);
            };
            reader.readAsDataURL(file);
        },
        getEmpSignature() {
            let photo = "";
            if (this.form.signature) {
                //console.log(this.form.employee_image)
                this.photo = this.form.signature;
            } else {
                this.photo = "/img/signature/signature.png";
                this.form.signature = "/img/signature/signature.png";
            }
            return this.photo;
        },

        createEmployeeInfo() {
            this.form.QualificationList = this.QualificationList;
            this.form.ExperianceList = this.ExperianceList;

            this.savingImage = true;

            console.log(this.form);
            this.form
                .post("/site/employee/employee-create")
                .then(({ data }) => {
                    console.log(data);
                    this.form.reset();

                    swal(
                        this.editMode ? "Update" : "Save",
                        data.message,
                        "success"
                    );
                })
                .catch(error => {
                    console.log(error);
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.savingImage = false;
                });
        },

        // present address
        getPresentSiteCountry() {
            //console.log("ok");
            axios
                .get(window.routesH.route_site_country_list)
                .then(({ data }) => {
                    //console.log(data);
                    this.PresentCountryList = data;
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {});
        },

        presentCountryChange() {
            this.PresentDivisionList = [];
            this.PresentDistrictList = [];
            this.PresentThanaList = [];

            if (this.form.present_country_id) {
                this.presentDivisionLoadingImg = true;
                axios
                    .get(
                        "/division/get-division-list/" +
                            this.form.present_country_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentDivisionList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentDivisionLoadingImg = false));
            }
        },

        presentDivisionChange() {
            this.PresentDistrictList = [];
            this.PresentThanaList = [];

            if (this.form.present_division_id) {
                this.presentDistrictLoadingImg = true;
                axios
                    .get(
                        "/district/get-district-list/" +
                            this.form.present_division_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentDistrictList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentDistrictLoadingImg = false));
            }
        },

        presentDistrictChange() {
            this.PresentThanaList = [];

            if (this.form.present_district_id) {
                this.presentThanaLoadingImg = true;
                axios
                    .get(
                        "/thana/get-thana-list/" + this.form.present_district_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentThanaList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentThanaLoadingImg = false));
            }
        },

        // Permanent address
        getPermanentSiteCountry() {
            axios
                .get(window.routesH.route_site_country_list)
                .then(({ data }) => {
                    //console.log(data);
                    this.PermanentCountryList = data;
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {});
        },

        permanentCountryChange() {
            this.PermanentDivisionList = [];
            this.PermanentDistrictList = [];
            this.PermanentThanaList = [];

            if (this.form.permanent_country_id) {
                this.permanentDivisionLoadingImg = true;
                axios
                    .get(
                        "/division/get-division-list/" +
                            this.form.permanent_country_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentDivisionList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.permanentDivisionLoadingImg = false));
            }
        },

        permanentDivisionChange() {
            this.PermanentDistrictList = [];
            this.PermanentThanaList = [];

            if (this.form.permanent_division_id) {
                this.permanentDistrictLoadingImg = true;
                axios
                    .get(
                        "/district/get-district-list/" +
                            this.form.permanent_division_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentDistrictList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.permanentDistrictLoadingImg = false));
            }
        },

        permanentDistrictChange() {
            this.PermanentThanaList = [];

            if (this.form.permanent_district_id) {
                this.permanentThanaLoadingImg = true;
                axios
                    .get(
                        "/thana/get-thana-list/" +
                            this.form.permanent_district_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentThanaList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.permanentThanaLoadingImg = false));
            }
        },

        permanentThanaChange() {
            if (this.form.permanent_thana_id != this.form.present_thana_id) {
                this.sameAddressSelect = false;
            }
        },

        SameAddress() {
            this.form.permanent_country_id = "";
            this.form.permanent_division_id = "";
            this.form.permanent_district_id = "";
            this.form.permanent_thana_id = "";
            this.form.PermanentAddress = "";
            console.log(this.sameAddressSelect);

            if (this.sameAddressSelect) {
                this.form.permanent_country_id = this.form.present_country_id;
                this.permanentCountryChange();
                this.form.permanent_division_id = this.form.present_division_id;
                this.permanentDivisionChange();
                this.form.permanent_district_id = this.form.present_district_id;
                this.permanentDistrictChange();
                this.form.permanent_thana_id = this.form.present_thana_id;
                this.form.permanent_address = this.form.present_address;
            }
        },

        empAction(empActionvalue) {
            console.log(empActionvalue);
            if (empActionvalue.emp_edit) {
                this.empEdit(empActionvalue.emp_user_id);
                this.tab = 2;
                $(".tab_11").removeClass("active");
                $(".tab_22").addClass("active");
                this.form_title = "Edit Employee";
                this.form.reset();
            }
        },

        empEdit(emp_user_id) {
            axios
                .get("/site/employee/get-employee-list-for-edit/" + emp_user_id)
                .then(({ data }) => {
                    console.log(data);
                    console.log(data[1]);
                    console.log(data[2]);

                    if (
                        data[0].name_native_language ||
                        data[0].date_of_birth ||
                        data[0].dept_join_date ||
                        data[0].contact_number ||
                        data[0].job_title ||
                        data[0].nationality ||
                        data[0].ntrc_registration_number ||
                        data[0].blood_group_id ||
                        data[0].transport_assign_id ||
                        data[0].academic_residence_id ||
                        data[0].academic_quata_id ||
                        data[0].emp_grade_id
                    ) {
                        this.PrimaryInfoShowHide = true;
                        this.getResidenceEmpgradeTransportQuataBloodgroupList();
                    }

                    if (
                        data[0].father_name ||
                        data[0].mother_name ||
                        data[0].spouse_name ||
                        data[0].number_of_children
                    ) {
                        this.PersonalInfoShowHide = true;
                    }

                    if (
                        data[0].birth_certificate_no ||
                        data[0].nid_number ||
                        data[0].email ||
                        data[0].passport_no ||
                        data[0].emergency_contact
                    ) {
                        this.CommunicationInfoShowHide = true;
                    }

                    if (data[1].length > 0) {
                        this.AcademicQualificationShowHide = true;
                        this.qualificationBarClick();
                        this.QualificationList = data[1];
                    }

                    if (data[2].length > 0) {
                        this.ExperianceInfoShowHide = true;
                        this.ExperianceList = data[2];
                    }

                    this.form.fill(data[0]);
                    this.form.present_address = data[0].address;
                    this.form.employee_image = data[0].latest_photo.name;
                    this.getProfilePhoto();

                    if (
                        data[0].present_country_id ||
                        data[0].permanent_country_id
                    ) {
                        this.AddressShowHide = true;
                        this.getPresentSiteCountry();
                        this.presentCountryChange();
                        this.presentDivisionChange();
                        this.presentDistrictChange();

                        this.getPermanentSiteCountry();
                        this.permanentCountryChange();
                        this.permanentDivisionChange();
                        this.permanentDistrictChange();
                    }

                    this.editMode = true;
                    this.formShow = true;

                    this.EmpFormBtnShow = true;
                    this.EmpListBtnShow = false;
                    this.ListShow = false;
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => (this.permanentThanaLoadingImg = false));
        },

        UpdateEmployeeInfo() {
            this.form.QualificationList = this.QualificationList;
            this.form.ExperianceList = this.ExperianceList;

            this.savingImage = true;

            this.form
                .post("/site/employee/employee-update")
                .then(({ data }) => {
                    console.log(data);
                    this.form.reset();
                    swal(
                        this.editMode ? "Update" : "Save",
                        data.message,
                        "success"
                    );
                    this.formShow = false;
                    this.ListShow = true;
                    this.tab = 1;
                    $(".tab_11").addClass("active");
                })
                .catch(error => {
                    console.log(error);
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.savingImage = false;
                });
        },

        changeTab(tab) {
            console.log(tab);

            if (tab == 2) {
                this.EmpFormBtnClick();
            }
            this.tab = tab;
        }
    },

    created() {
        this.getDesignationReligionGender();
    }
};
