import VueCtkDateTimePicker from "vue-ctk-date-time-picker";
import "vue-ctk-date-time-picker/dist/vue-ctk-date-time-picker.css";
Vue.component("VueCtkDateTimePicker", VueCtkDateTimePicker);
import Multiselect from "vue-multiselect";

import Datepicker from "vuejs-datepicker";
import SiteBaseStudentListComponent from "@/components/student/SiteBaseStudentListComponent.vue";
import DetailsComponent from "@/components/site/student/details/DetailsComponent.vue";
export default {

    components: { Multiselect, Datepicker, SiteBaseStudentListComponent, DetailsComponent },
    computed: {},
    // mounted: function() {
    //     var self = this;
    //     $("#datepicker").datepicker({
    //       dateFormat: "dd MM, yy",
    //       changeMonth: true,
    //       changeYear: true,
    //       showAnim: "slideDown",
    //       yearRange: "-50:+0",
    //       onSelect: function(selectedDate, datePicker) {
    //         // console.log(selectedDate);
    //         self.form.date_of_birth = selectedDate;
    //       }
    //     });
    //   },
    data() {
        return {
            studentListShow: true,
            studentFormShow: false,
            StdListBtnShow: false,
            StdFormBtnShow: true,
            studentDetailsShow: false,
            loadingBatch:false,

            loadingPage: false,
            loadingClass: false,

            dataloadingImage: false,
            editMode: false,
            //  FixedDataShowHide:true,
            id: "",
            site_info_id: "",
            academic_department_id: null,
            departmentList: [],

            AcademicVersionList: [],
            academic_version_id: null,

            getGenderList: [],
            ReligionList: [],
            AcademicSectionList: [],
            academic_section_id: null,

            student_history_id: "",
            studentHistoryList: [],

            academic_class_group_id: null,
            AcademicClassGroupList: [],

            academic_year_id: null,
            AcademicYearList: [],

            academic_session_id: null,
            AcademicSessionList: [],

            academic_shift_id: null,
            AcademicShiftList: [],

            academic_class_id: null,
            AcademicClassList: [],

            AcademicKey:null,

            site_batch_detail_id:null,
            SiteBatchList:[],

            FatherOccupationList: [],
            MotherOccupationList: [],
            getQuataList: [],

            getStudentTypeList: [],
            academic_student_type_id: null,

            ReligionSubjectList: [],
            OptionalSubjectList: [],
            MarkinglessSubjectList: [],
            CompulsorySubjectList: [],
            SelectiveCompulsorySubjectList: [],

            getResidenceList: [],

            compulsory_subject_limit: null,
            optional_subject_limit: null,

            academic_student_category_id: null,
            AcademicStudentCategoryList: [],

            // present address
            PresentCountryList: [],
            PresentDivisionList: [],
            PresentDistrictList: [],
            PresentThanaList: [],

            // Permanent address
            PermanentCountryList: [],
            PermanentDivisionList: [],
            PermanentDistrictList: [],
            PermanentThanaList: [],

            presentDivisionLoadingImg: false,
            presentDistrictLoadingImg: false,
            presentThanaLoadingImg: false,
            gettingStudentForEditImg: false,

            permanentDivisionLoadingImg: false,
            permanentDistrictLoadingImg: false,
            permanentThanaLoadingImg: false,

            sameAddressSelect: false,
            GurdianInfoShowHide: false,
            PrimaryInfoShowHide: false,

            getBloodGroupList: [],

            getStudentAdmissionTypeList: [],
            academic_student_admission_type_id: null,

            AddressShowHide: false,
            CommunicationInfoShowHide: false,
            PreviousInfoHideShow: false,
            LocalGurdianHideShow: false,
            whenYearClassSelect: false,
            FundamentalInfoShowHide: true,
            date_of_birth: "",

            academic_year_name: "",
            academic_session_name: "",
            academic_shift_name: "",
            academic_class_name: "",
            site_batch_detail_name:"",
            academic_group_name: "",
            academic_section_name: "",
            academic_category_name: "",

            student_for_edit: null,
            student_for_edit: "",
            RelationList: [],
            whenEditClick: false,

            edit_academic_version_id: null,
            edit_academic_year_id: null,
            edit_academic_shift_id: null,
            edit_academic_class_id: null,
            edit_site_batch_detail_id: null,
            edit_academic_department_id: null,
            edit_academic_class_group_id: null,
            edit_academic_section_id: null,
            edit_academic_student_category_id: null,
            edit_academic_session_id: null,
            edit_academic_student_type_id: null,
            edit_academic_student_admission_type_id: null,
            loadingStudentInsert: false,

            form: new Form({
                id: "",
                student_history_id:"",
                status: "",

                gender_id: null,
                academic_residence_id: null,
                religion_id: null,
                blood_group_id: null,
                student_image: "",

                // academic_version_id: null,
                // academic_year_id: null,
                // academic_shift_id: null,
                // academic_class_id: null,
                // academic_department_id: null,
                // academic_class_group_id: null,
                // academic_section_id: null,
                // academic_student_category_id: null,
                // academic_session_id: null,
                // academic_student_type_id: null,
                // academic_student_admission_type_id: null,

                present_country_id: null,
                present_division_id: null,
                present_district_id: null,
                present_thana_id: null,
                present_address: "",

                permanent_country_id: null,
                permanent_division_id: null,
                permanent_district_id: null,
                permanent_thana_id: null,
                permanent_address: "",

                first_name: "",
                last_name: "",
                name_native_language: "",
                student_roll_number_prefix: "",
                student_roll_number: "",
                father_name: "",
                mother_name: "",
                date_of_birth: "",
                student_contact_number: "",
                student_registration_number: "",
                board_registration_number: "",
                board_roll_number: "",
                academic_quata_id: null,

                religion_subject_id: "",

                father_occupation_id: null,
                father_yearly_income: "",
                father_contact_number: "",
                father_email: "",

                mother_occupation_id: null,
                mother_yearly_income: "",
                mother_contact_number: "",
                mother_email: "",

                student_birth_certificate_no: "",
                student_national_id: "",
                student_mobile_number: "",
                student_email_id: "",
                student_passport_number: "",
                student_emergency_contact_number: "",

                previous_institute_name: "",
                previous_academic_class_id: null,
                previous_academic_department_id: null,
                previous_gpa: "",
                previous_marks: "",
                previous_institute_location: "",
                tc_number: "",
                tc_date: "",

                local_gurdian_name: "",
                relation_id: null,
                local_gurdian_mobile: "",
                local_gurdian_address: "",
                local_gurdian_email: "",

                compulsory_subject_ids: [],
                selective_compulsory_subject_ids:[],
                optional_subject_ids: [],
                selective_markingless_subject_ids: [],
                user_id: "",

                compulsory_subject_limit:null,
                optional_subject_limit:null,

                AcademicSessionList: [],
            }),
            ssct: new Form({
                id: ""
            })
        };
    },
    methods: {
        // dateChange(){
        //   console.log(this.form.date_of_birth);
        // },

        nameWithRoll({ full_name, student_full_roll_number }) {
            let student_full_roll_numbers = student_full_roll_number
                ? " - (" + student_full_roll_number + ")"
                : "";
            return full_name + student_full_roll_numbers;
        },

        StdListBtnClick() {
            this.studentListShow = true;
            this.studentFormShow = false;
            this.StdListBtnShow = false;
            this.StdFormBtnShow = true;
        },
        StdFormBtnClick() {
            this.studentListShow = false;
            this.studentFormShow = true;
            this.StdListBtnShow = true;
            this.StdFormBtnShow = false;
            this.studentHistoryList = [];
            this.form.reset();
            this.getSiteYearShiftClassSessionVersionConditionList();

            this.PrimaryInfoShowHide = false;
            this.GurdianInfoShowHide = false;
            this.CommunicationInfoShowHide = false;
            this.PreviousInfoHideShow = false;
            this.LocalGurdianHideShow = false;
            this.AddressShowHide = false;
        },

        createStudentInfo() {
            this.form.academic_version_id = this.academic_version_id;
            this.form.academic_year_id = this.academic_year_id;
            this.form.academic_shift_id = this.academic_shift_id;
            this.form.academic_class_id = this.academic_class_id;
            this.form.academic_department_id = this.academic_department_id;
            this.form.academic_class_group_id = this.academic_class_group_id;
            this.form.academic_section_id = this.academic_section_id;
            this.form.academic_student_category_id = this.academic_student_category_id;
            this.form.academic_session_id = this.academic_session_id;
            this.form.academic_student_type_id = this.academic_student_type_id;
            this.form.academic_student_admission_type_id = this.academic_student_admission_type_id;

            this.form.AcademicSessionList = this.AcademicSessionList;
            this.form.ReligionSubjectList = this.ReligionSubjectList;


            this.form.compulsory_subject_limit = this.compulsory_subject_limit;
            this.form.optional_subject_limit = this.optional_subject_limit;
            this.form.site_batch_detail_id = this.site_batch_detail_id;
            // console.log(this.form);

            this.loadingStudentInsert = true;

            this.form
                .post("/student/student-create")
                .then(({ data }) => {
                    console.log(data);
                    swal(
                        this.editMode ? "Update" : "Save",
                        data.message,
                        "success"
                    );

                    this.form.reset();
                    this.GurdianInfoShowHide = false;
                    this.CommunicationInfoShowHide = false;
                    this.PreviousInfoHideShow = false;
                    this.LocalGurdianHideShow = false;
                    this.AddressShowHide = false;
                })
                .catch(error => {
                    // console.log(error.response.status);
                    let status = error.response.status;

                    if (status == "412") {
                        swal("Error!", error.response.data.message, "error");
                        return;
                    }
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingStudentInsert = false;
                });
        },


        UpdateStudentInfo() {
            this.form.academic_class_group_id = this.academic_class_group_id;
            if (this.AcademicSectionList.length > 0) {
                this.form.academic_section_id = this.academic_section_id;
            } else {
                this.form.academic_section_id = null;
            }

            this.form.academic_version_id = this.academic_version_id;
            this.form.academic_year_id = this.academic_year_id;
            this.form.academic_shift_id = this.academic_shift_id;
            this.form.academic_class_id = this.academic_class_id;
            this.form.academic_department_id = this.academic_department_id;

            this.form.academic_student_category_id = this.academic_student_category_id;
            this.form.academic_session_id = this.academic_session_id;
            this.form.academic_student_type_id = this.academic_student_type_id;
            this.form.academic_student_admission_type_id = this.academic_student_admission_type_id;
            this.whenEditClick = true;

            this.form.AcademicSessionList = this.AcademicSessionList;
            this.form.ReligionSubjectList = this.ReligionSubjectList;

            this.form.compulsory_subject_limit = this.compulsory_subject_limit;
            this.form.optional_subject_limit = this.optional_subject_limit;
            this.form.site_batch_detail_id = this.site_batch_detail_id;

            this.student_history_id=this.form.student_history_id;

            this.loadingStudentInsert = true;

            console.log("ok");
            console.log(this.student_history_id);
            this.form
                .post("/student/student-edit/" + this.student_history_id)
                .then(({ data }) => {
                    console.log(data);

                    swal(
                        this.editMode ? "Update" : "Save",
                        data.message,
                        "success"
                    );

                    this.form.reset();
                    this.GurdianInfoShowHide = false;
                    this.CommunicationInfoShowHide = false;
                    this.PreviousInfoHideShow = false;
                    this.LocalGurdianHideShow = false;
                    this.AddressShowHide = false;

                    this.academic_version_id = this.edit_academic_version_id;
                    this.academic_year_id = this.edit_academic_year_id;
                    this.academic_shift_id = this.edit_academic_shift_id;
                    this.academic_class_id = this.edit_academic_class_id;
                    this.site_batch_detail_id = this.edit_site_batch_detail_id;
                    this.academic_department_id = this.edit_academic_department_id;

                    this.academic_class_group_id = this.edit_academic_class_group_id;
                    this.academic_section_id = this.edit_academic_section_id;
                    this.academic_student_category_id = this.edit_academic_student_category_id;
                    this.academic_session_id = this.edit_academic_session_id;
                    this.academic_student_type_id = this.edit_academic_student_type_id;
                    this.academic_student_admission_type_id = this.edit_academic_student_admission_type_id;

                    this.editMode = false;

                    if (this.student_for_edit == null) {
                        this.studentListShow = true;
                        this.studentFormShow = false;
                        this.StdListBtnShow = false;
                        this.StdFormBtnShow = true;

                        this.edit_academic_version_id = null;
                        this.edit_academic_year_id = null;
                        this.edit_academic_shift_id = null;
                        this.edit_academic_class_id = null;
                        this.edit_site_batch_detail_id = null;
                        this.edit_academic_department_id = null;
                        this.edit_academic_class_group_id = null;
                        this.edit_academic_section_id = null;
                        this.edit_academic_student_category_id = null;
                        this.edit_academic_session_id = null;
                        this.edit_academic_student_type_id = null;
                        this.edit_academic_student_admission_type_id = null;

                        this.FundamentalInfoShowHide = true;
                    }

                    this.student_history_id = "";
                    this.student_for_edit = null;
                })
                .catch(error => {
                    // console.log(error.response);
                    let status = error.response.status;
                    if (status == "412") {
                        swal("Error!", error.response.data.message, "error");
                        return;
                    }
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingStudentInsert = false;
                });
        },

        changeBatch(){

        },

        blankWithOutForm() {
            this.AcademicVersionList = [];
            this.AcademicYearList = [];
            this.AcademicShiftList = [];
            this.AcademicClassList = [];
            this.AcademicClassGroupList = [];
            this.AcademicStudentCategoryList = [];
            this.AcademicSessionList = [];
            this.getStudentAdmissionTypeList = [];
            this.getStudentTypeList = [];
            this.RelationList = [];
            this.departmentList = [];
            // this.studentHistoryList = [];

            this.academic_version_id = null;
            this.academic_year_id = null;
            this.academic_shift_id = null;
            this.academic_class_id = null;
            this.academic_department_id = null;
            this.academic_class_group_id = null;
            this.academic_section_id = null;
            this.academic_student_category_id = null;
            this.academic_session_id = null;
            this.academic_student_type_id = null;
            this.academic_student_admission_type_id = null;
        },

        getSiteYearShiftClassSessionVersionConditionList() {
            this.blankWithOutForm();

            this.loadingPage = true;
            axios
                .get("/student/site-year-shift-department-class-session-version-condition-load/")
                .then(({ data }) => {
                    // console.log(data);
                    this.AcademicVersionList = data[0];
                    this.AcademicYearList = data[1];
                    this.AcademicShiftList = data[2];
                     this.AcademicClassList = data[3];
                     this.AcademicSessionList = data[3];
                    this.getStudentAdmissionTypeList = data[3];
                    this.getStudentTypeList = data[4];
                    this.RelationList = data[5];
                  //  this.AcademicKey = data[6];
                    // this.departmentList = data[7];


                    if (data[2].length > 0) {
                        console.log(data[2][0].id);
                        this.academic_shift_id = data[2][0].id;
                      }
                      if (data[0].length > 0) {
                        this.academic_version_id = data[0][0].id;
                      }
                      if (data[1].length > 0) {
                        this.academic_year_id = data[1][0].id;
                        this.ChangeVersionYearShift();
                      }


                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingPage = false;
                });
        },

        ChangeVersionYear() {
            this.AcademicClassList = [];
            this.departmentList = [];

            this.loadingClass = true;
            axios
                .get(
                    "/site/shift-class-group-section-setting/get-site-year-version-base-department-class/" +
                        this.academic_version_id +
                        "/" +
                        this.academic_year_id
                )
                .then(({ data }) => {
                    // console.log(data);
                    this.AcademicClassList = data[0];
                    this.departmentList = data[1];
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingClass = false;
                });
        },

        onChangeDepartment() {
            this.AcademicClassList = [];
            this.form.academic_class_id = null;

            axios
                .get(
                    "/site/shift-class-group-section-setting/get-department-base-class-list/" +
                        this.academic_department_id
                )
                .then(({ data }) => {
                    console.log(data);
                    this.AcademicClassList = data;

                    // this.academic_group_id = academic_group_id;
                })
                .catch(function(error) {
                    swal("Error!", error.response.data.message, "error");
                })
                .finally(() => {});
        },


        changeClass() {

            // this.AcademicClassGroupList = [];
            // this.AcademicSectionList = [];
            // this.academic_section_id = null;
            // this.academic_class_group_id = null;
            // this.studentHistoryList = [];

            axios
              .get(
                "/site/academic/get-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class/" +
                  this.academic_version_id +
                  "/" +
                  this.academic_year_id +
                  "/" +
                  this.academic_shift_id +
                  "/" +
                  this.academic_class_id +
                  "/" +
                  this.academic_department_id
              )
              .then(({ data }) => {
                console.log(data);

                this.AcademicClassGroupList = data[0];
                this.AcademicSectionList = data[1];
                this.academicSessionList = data[2];
                this.SiteBatchList = data[3];




                if (this.academic_class_id) {

                    if(!this.editMode){
                        this.form.reset();
                    }


                    this.whenYearClassSelect = true;
                    // this.ClassBaseGroupSection();
                    this.getClassGroupBaseSelectiveSubject();
                    this.changeSectionSessionConditionType();

                    this.getGenderReligionBloodStudentCategoryQuataOccupation();


                    if(!this.editMode){
                        this.student_for_edit = null;
                        this.academic_class_group_id = null;
                        this.academic_section_id = null;
                        this.academic_student_category_id = null;
                        this.academic_session_id = null;
                        this.academic_student_type_id = null;
                        this.academic_student_admission_type_id = null;

                        this.PrimaryInfoShowHide = true;
                        this.GurdianInfoShowHide = false;
                        this.CommunicationInfoShowHide = false;
                        this.PreviousInfoHideShow = false;
                        this.LocalGurdianHideShow = false;
                        this.AddressShowHide = false;
                    }


                } else {
                    this.whenYearClassSelect = false;
                }

              })
              .catch(error => {
                toast({
                  type: "warning",
                  title: error.response.data.message
                });
              })
              .finally(() => {
                this.gettingData = false;
                this.$emit("getStatus", {
                  gettingData: this.gettingData
                });
              });
        },


        fundamentalbar() {
            if (
                !this.academic_version_id ||
                !this.academic_year_id ||
                !this.academic_shift_id ||
                !this.academic_class_id ||
                !this.academic_student_category_id
            ) {
                this.FundamentalInfoShowHide = true;
            } else {
                this.FundamentalInfoShowHide = false;
            }

            //version name show
            var version_id = this.academic_version_id;
            var academic_version_name;
            $.each(this.AcademicVersionList, function(a, b) {
                if (version_id == b.id) {
                    academic_version_name = b.version_name;
                }
            });
            this.academic_version_name = academic_version_name;

            //academic year name show
            var year_id = this.academic_year_id;
            var academic_year_name;
            $.each(this.AcademicYearList, function(a, b) {
                if (year_id == b.id) {
                    academic_year_name = b.year_name;
                }
            });
            this.academic_year_name = academic_year_name;

            //academic session name show
            var session_id = this.academic_session_id;
            var academic_session_name;
            $.each(this.AcademicSessionList, function(a, b) {
                if (session_id == b.id) {
                    academic_session_name = b.session_name;
                }
            });

            this.academic_session_name = academic_session_name;

            //academic shift name show
            var shift_id = this.academic_shift_id;
            var academic_shift_name;
            $.each(this.AcademicShiftList, function(a, b) {
                if (shift_id == b.id) {
                    academic_shift_name = b.shift_name;
                }
            });
            this.academic_shift_name = academic_shift_name;

            //academic class name show
            var department_id = this.academic_department_id;
            var academic_department_name;
            $.each(this.departmentList, function(a, b) {
                if (department_id == b.id) {
                    academic_department_name = b.name;
                }
            });
            this.academic_department_name = academic_department_name;

            //academic class name show
            var class_id = this.academic_class_id;
            var academic_class_name;
            $.each(this.AcademicClassList, function(a, b) {
                if (class_id == b.id) {
                    academic_class_name = b.class_name;
                }
            });
            this.academic_class_name = academic_class_name;


            //site Batch name show
            var site_batch_detail_id = this.site_batch_detail_id;
            var site_batch_detail_name;
            $.each(this.SiteBatchList, function(a, b) {
                if (site_batch_detail_id == b.id) {
                    site_batch_detail_name = b.batch_name;
                }
            });
            this.site_batch_detail_name = site_batch_detail_name;


            //academic class group name show
            var class_group_id = this.academic_class_group_id;
            var academic_group_name;
            $.each(this.AcademicClassGroupList, function(a, b) {
                if (class_group_id == b.id) {
                    academic_group_name = b.group_name;
                }
            });
            this.academic_group_name = academic_group_name;

            //academic section name show
            var section_id = this.academic_section_id;
            var academic_section_name;
            $.each(this.AcademicSectionList, function(a, b) {
                if (section_id == b.id) {
                    academic_section_name = b.section_name;
                }
            });
            this.academic_section_name = academic_section_name;

            //academic student category name show
            var category_id = this.academic_student_category_id;
            var academic_category_name;

            $.each(this.AcademicStudentCategoryList, function(a, b) {
                if (category_id == b.id) {
                    academic_category_name = b.category_name;
                    //  console.log(b.category_name);
                }
            });
            this.academic_category_name = academic_category_name;

            //show Student condition name
            var student_type_id = this.academic_student_type_id;
            var academic_student_type_name;
            $.each(this.getStudentTypeList, function(a, b) {
                if (student_type_id == b.id) {
                    academic_student_type_name = b.student_type_name;
                }
            });
            this.academic_student_type_name = academic_student_type_name;

            //show Student Admission type name
            var admission_type_id = this.academic_student_admission_type_id;
            var academic_admission_type_name;
            $.each(this.getStudentAdmissionTypeList, function(a, b) {
                if (admission_type_id == b.id) {
                    academic_admission_type_name = b.admission_type_name;
                }
            });
            this.academic_admission_type_name = academic_admission_type_name;
        },

        browse() {
            document.querySelector("input[type=file]").click();
        },

        studentImageSelect(event) {
            let file = event.target.files[0];
            //console.log(file);
            let reader = new FileReader();
            let limit = 1024 * 1024 * 2;

            if (file["size"] > limit) {
                swal({
                    type: "error",
                    title: "Oops...",
                    text: "You are uploading a large file"
                });
                return false;
            }
            reader.onloadend = file => {
                this.form.student_image = reader.result;
                // console.log(reader.result);
            };
            reader.readAsDataURL(file);
        },

        getProfilePhoto() {
            // console.log("f " + this.form.student_image);
            let photo = "";
            if (this.form.student_image) {
                //console.log(this.form.student_image)
                this.photo =
                    this.form.student_image.length > 200
                        ? this.form.student_image
                        : "/uploads/" + this.form.student_image;
            } else {
                this.photo = "/uploads/image-not.png";
                this.form.student_image = "image-not.png";
            }
            return this.photo;
        },

        getGenderReligionBloodStudentCategoryQuataOccupation() {
            this.getGenderList = [];
            this.getResidenceList = [];
            this.ReligionList = [];
            this.getBloodGroupList = [];
            this.AcademicStudentCategoryList = [];
            this.getQuataList = [];
            this.FatherOccupationList = [];
            this.MotherOccupationList = [];

            axios
                .get(
                    "/student/get-gender-religion-blood-student-category-quata-occupation-list"
                )
                .then(({ data }) => {
                    // console.log(data);
                    this.getGenderList = data[0];
                    this.ReligionList = data[1];
                    this.getBloodGroupList = data[2];
                    this.AcademicStudentCategoryList = data[3];
                    this.getQuataList = data[4];
                    this.FatherOccupationList = data[5];
                    this.MotherOccupationList = data[5];
                    this.getResidenceList = data[6];

                    if (data[3].length == 1) {
                        // console.log(data[2][0].id);
                        this.academic_student_category_id = data[3][0].id;
                    }
                    //gender auto selection if only one
                    if (data[0].length == 1) {
                        // console.log(data[2][0].id);
                        this.form.gender_id = data[0][0].id;
                    }
                })
                .catch(function(error) {
                    // console.log(error);
                })
                .finally(() => {});
        },

        ChangeVersionYearShift() {
            this.academic_class_id = null;
            this.loadingClass = true;
            this.gettingData = true;

            this.AcademicClassList = [];
            this.departmentList = [];

            this.academic_class_group_id = null;
            this.AcademicClassGroupList = [];

            this.AcademicSectionList = [];
            this.academic_section_id = null;

            this.academic_session_id = null;
            this.academicSessionList = [];

            this.academic_department_id = null;
            this.departmentList = [];

            this.academic_class_id = null;
            this.AcademicClassList = [];

            this.$emit("getStatus", {
              gettingData: this.gettingData
            });

            axios
              .get(
                "/site/shift-class-group-section-setting/get-site-year-version-shift-based-department-class",
                {
                  params: {
                    academic_version_id: this.academic_version_id,
                    academic_year_id: this.academic_year_id,
                    academic_shift_id: this.academic_shift_id
                  }
                }
              )
              .then(({ data }) => {
                console.log(data);
                this.AcademicClassList = data[0];
                this.departmentList = data[1];
              })
              .catch(error => {
                toast({
                  type: "warning",
                  title: error.response.data.message
                });
              })
              .finally(() => {
                this.loadingClass = false;
              });
          },

        // ClassShiftChange() {
        //     this.AcademicClassGroupList = [];
        //     this.AcademicSectionList = [];
        //     this.academic_section_id = null;
        //     this.academic_class_group_id = null;
        //     this.studentHistoryList = [];

        //     if (this.academic_class_id) {
        //         this.form.reset();

        //         this.whenYearClassSelect = true;
        //         this.ClassBaseGroupSection();
        //         this.getClassGroupBaseSelectiveSubject();
        //         this.changeSectionSessionConditionType();

        //         this.getGenderReligionBloodStudentCategoryQuataOccupation();

        //         this.student_for_edit = null;
        //         this.academic_class_group_id = null;
        //         this.academic_section_id = null;
        //         this.academic_student_category_id = null;
        //         this.academic_session_id = null;
        //         this.academic_student_type_id = null;
        //         this.academic_student_admission_type_id = null;

        //         this.PrimaryInfoShowHide = true;
        //         this.GurdianInfoShowHide = false;
        //         this.CommunicationInfoShowHide = false;
        //         this.PreviousInfoHideShow = false;
        //         this.LocalGurdianHideShow = false;
        //         this.AddressShowHide = false;
        //     } else {
        //         this.whenYearClassSelect = false;
        //     }
        // },

        academicGroupChange() {
            this.AcademicSectionList = [];
            this.academic_section_id = null;

            if (this.academic_class_id) {
                if (this.student_for_edit) {
                    this.ClassBaseGroupSection();
                    this.getClassGroupBaseSelectiveSubject();
                } else {
                    this.whenYearClassSelect = true;

                    this.ClassBaseGroupSection();
                    this.getClassGroupBaseSelectiveSubject();
                    this.changeSectionSessionConditionType();

                    this.academic_section_id = null;
                    this.academic_student_category_id = null;
                    this.academic_session_id = null;
                    this.academic_student_type_id = null;
                    this.academic_student_admission_type_id = null;

                    // this.GurdianInfoShowHide = false;
                    // this.CommunicationInfoShowHide = false;
                    // this.PreviousInfoHideShow = false;
                    // this.LocalGurdianHideShow = false;
                    // this.AddressShowHide = false;
                }
            } else {
                this.whenYearClassSelect = false;
            }
        },

        changeSectionSessionConditionType() {
            if (this.student_for_edit) {
                return;
            } else {
                this.studentHistoryList = [];
                this.student_for_edit = null;
                this.ssct.academic_version_id = this.academic_version_id;
                this.ssct.academic_year_id = this.academic_year_id;
                this.ssct.academic_class_id = this.academic_class_id;
                this.ssct.academic_department_id = this.academic_department_id;
                this.ssct.academic_shift_id = this.academic_shift_id;
                this.ssct.academic_class_group_id = this.academic_class_group_id;
                this.ssct.academic_section_id = this.academic_section_id;
                this.ssct.academic_student_category_id = this.academic_student_category_id;
                this.ssct.academic_session_id = this.academic_session_id;
                this.ssct.academic_student_type_id = this.academic_student_type_id;
                this.ssct.academic_student_admission_type_id = this.academic_student_admission_type_id;

                this.ssct
                    .post("/student/section-category-type-admission-type")
                    .then(({ data }) => {
                        console.log(data);
                        this.studentHistoryList = data;
                    })
                    .catch(error => {
                        // console.log(error);
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => {
                        this.savingImage = false;
                    });
            }
        },

        ClassBaseGroupSection() {
            this.AcademicSectionList = [];
            this.AcademicSessionList = [];

            if (this.academic_shift_id) {
                var academic_shift = this.academic_shift_id;
            } else {
                var academic_shift = 0;
            }

            if (this.academic_class_group_id) {
                var academic_group = this.academic_class_group_id;
            } else {
                var academic_group = 0;
            }

            if (this.academic_year_id) {
                var year_id = this.academic_year_id;
            } else {
                var year_id = 0;
            }

            var version_id=this.academic_version_id;



            axios
                .get(
                    "/student/get-site-class-base-section/" +
                        this.academic_class_id +
                        "/" +
                        academic_shift +
                        "/" +
                        academic_group +
                        "/" +
                        year_id+
                        "/" +
                        version_id
                )
                .then(({ data }) => {
                    console.log(data);

                    if (data[0] == 2001) {
                        this.AcademicClassGroupList = data[1];
                        this.AcademicSessionList = data[2];

                        // if(data[1].length==1){
                        //   console.log(data[1][0].id)
                        //   this.academic_class_group_id=data[1][0].id;~
                        // }
                    } else if (data == 4001) {
                        return;
                    } else {
                        this.AcademicSectionList = data[0];
                        this.AcademicSessionList = data[1];
                    }
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {});
        },

        changeStudentForEdit() {
            this.form.reset();

            //console.log(this.student_for_edit.id);
            if (!this.student_for_edit) {
                this.editMode = false;
                this.GurdianInfoShowHide = false;
                this.CommunicationInfoShowHide = false;
                this.PreviousInfoHideShow = false;
                this.LocalGurdianHideShow = false;
                this.AddressShowHide = false;
                return false;
            } else {
                this.gettingStudentForEditImg = true;
                this.student_for_edit_id = this.student_for_edit.id;

                this.editMode = true;

                this.GurdianInfoShowHide = false;
                this.CommunicationInfoShowHide = false;
                this.PreviousInfoHideShow = false;
                this.LocalGurdianHideShow = false;
                this.AddressShowHide = false;

                this.edit_academic_version_id = this.academic_version_id;
                this.edit_academic_year_id = this.academic_year_id;
                this.edit_academic_shift_id = this.academic_shift_id;
                this.edit_academic_class_id = this.academic_class_id;
                this.edit_site_batch_detail_id = this.site_batch_detail_id;
                this.edit_academic_department_id = this.academic_department_id;
                this.edit_academic_class_group_id = this.academic_class_group_id;
                this.edit_academic_section_id = this.academic_section_id;
                this.edit_academic_student_category_id = this.academic_student_category_id;
                this.edit_academic_session_id = this.academic_session_id;
                this.edit_academic_student_type_id = this.academic_student_type_id;
                this.edit_academic_student_admission_type_id = this.academic_student_admission_type_id;

                axios
                    .get(
                        "/student/get-student-detail-for-edit/" +
                            this.student_for_edit_id
                    )
                    .then(({ data }) => {

                        this.academic_year_id = data.academic_year_id;
                        this.academic_shift_id = data.academic_shift_id;
                        this.ChangeVersionYear();
                        if (this.academic_department_id) {
                            this.academic_department_id =
                                data.academic_department_id;
                            this.onChangeDepartment();
                            this.academic_class_id = data.academic_class_id;
                        } else {
                            this.academic_class_id = data.academic_class_id;
                        }

                        this.changeClass();
                        this.academic_session_id=data.academic_session_id;
                        this.site_batch_detail_id=data.site_batch_detail_id;
                        this.academic_section_id=data.academic_section_id;
                        this.academic_student_category_id=data.academic_student_category_id;
                        this.academic_student_type_id=data.academic_student_type_id;
                        this.academic_student_admission_type_id=data.academic_student_admission_type_id;
                        this.guardian_student_relation_id=data.guardian_student_relation_id;

                        // this.changeSectionSessionConditionType();
                        // this.ClassBaseGroupSection();
                        // this.getGenderReligionBloodStudentCategoryQuataOccupation();
                        this.student_contact_number=data.contact_number;

                        this.form.fill(data);
                        // this.form.compulsory_subject_ids = [];
                        // this.form.optional_subject_ids = [];
                        // this.form.selective_markingless_subject_ids = [];

                        // this.form.religion_subject_id=parseInt(data.religion_subject_id);

                        this.form.student_image = data.latest_photo
                            ? data.latest_photo.name
                            : null;

                        // this.form.compulsory_subject_ids = data
                        //     .compulsory_subject_ids[1]
                        //     ? data.compulsory_subject_ids[1]
                        //     : [];
                        // this.form.optional_subject_ids = data
                        //     .optional_subject_ids[1]
                        //     ? data.optional_subject_ids[1]
                        //     : [];
                        // this.form.selective_markingless_subject_ids = data
                        //     .selective_markingless_subject_ids[1]
                        //     ? data.selective_markingless_subject_ids[1]
                        //     : [];


                        this.form.selective_compulsory_subject_ids = data.selective_compulsory_subject_ids[1]
                            ? data.selective_compulsory_subject_ids[1].length==1?data.selective_compulsory_subject_ids[1][0]:data.selective_compulsory_subject_ids[1]
                            : [];
                        this.form.optional_subject_ids = data.optional_subject_ids[1]
                            ? data.optional_subject_ids[1].length==1?data.optional_subject_ids[1][0]:data.optional_subject_ids[1]
                            : [];
                        this.form.selective_markingless_subject_ids = data
                            .selective_markingless_subject_ids[1]
                            ? data.selective_markingless_subject_ids[1].length==1?data.selective_markingless_subject_ids[1][0]:data.selective_markingless_subject_ids[1]
                            : [];

    // console.log([this.form.compulsory_subject_ids, this.form.optional_subject_ids, 'ok' ])

                        // data.compulsory_subject_ids == null
                        //     ? []
                        //     : data.compulsory_subject_ids
                        //           .split(",")
                        //           .forEach(element => {
                        //               this.form.compulsory_subject_ids
                        //                   .push(parseInt(element))
                        //                   .toString();
                        //           });

                        // data.optional_subject_ids == null
                        //     ? []
                        //     : data.optional_subject_ids
                        //           .split(",")
                        //           .forEach(element => {
                        //               this.form.optional_subject_ids
                        //                   .push(parseInt(element))
                        //                   .toString();
                        //           });

                        // data.selective_markingless_subject_ids == null
                        //     ? []
                        //     : data.selective_markingless_subject_ids
                        //           .split(",")
                        //           .forEach(element => {
                        //               this.form.selective_markingless_subject_ids
                        //                   .push(parseInt(element))
                        //                   .toString();
                        //           });

                        if (
                            data.father_email ||
                            data.father_contact_number ||
                            data.father_occupation_id ||
                            data.father_yearly_income ||
                            data.mother_email ||
                            data.mother_contact_number ||
                            data.mother_occupation_id ||
                            data.mother_yearly_income
                        ) {
                            this.GurdianInfoShowHide = true;
                        }

                        if (
                            data.birth_certificate_no ||
                            data.nid_number ||
                            data.passport_no ||
                            data.email ||
                            data.emergency_contact
                        ) {
                            this.CommunicationInfoShowHide = true;
                        }

                        if (data.previous_institute_name) {
                            this.PreviousInfoHideShow = true;
                        }

                        if (data.local_gurdian_name) {
                            this.LocalGurdianHideShow = true;
                        }

                        if (data.present_country_id) {
                            this.AddressShowHide = true;
                            this.getPresentSiteCountry();
                            this.presentCountryChange();
                            this.presentDivisionChange();
                            this.presentDistrictChange();
                        }

                        if (data.permanent_country_id) {
                            this.AddressShowHide = true;
                            this.getPermanentSiteCountry();
                            this.permanentCountryChange();
                            this.permanentDivisionChange();
                            this.permanentDistrictChange();
                        }

                        // console.log('sfsfsfsfsfsfv');
                        // console.log(data.student_history_id);

                        this.student_history_id = data.student_history_id;
                        this.form.student_contact_number = data.contact_number;
                        this.form.present_address = data.address;

                        this.academic_class_group_id = data.academic_class_group_id
                            ? data.academic_class_group_id
                            : "";
                        if (data.academic_class_group_id) {
                            this.academicGroupChange();
                        }

                        this.academic_section_id = data.academic_section_id;

                        this.academic_student_category_id =
                            data.academic_student_category_id;

                        this.academic_session_id = data.academic_session_id;
                        this.academic_student_type_id =
                            data.academic_student_type_id;
                        this.academic_student_admission_type_id =
                            data.academic_student_admission_type_id;

                        this.form.previous_marks = data.previous_exam_mark;
                        this.form.student_birth_certificate_no =
                            data.birth_certificate_no;
                        this.form.student_national_id = data.nid_number;
                        this.form.student_email_id = data.email;
                        this.form.student_contact_number = data.contact_number;
                        this.form.student_passport_number = data.passport_no;
                        this.form.student_emergency_contact_number =
                            data.emergency_contact;
                        this.form.relation_id =
                            data.guardian_student_relation_id;
                        this.student_history_id =
                            data.student_history_id;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => {
                        this.gettingStudentForEditImg = false;
                    });
            }
        },

        getClassGroupBaseSelectiveSubject() {
            if (this.academic_class_group_id) {
                var academic_group = this.academic_class_group_id;
            } else {
                var academic_group = 0;
            }

            axios
                .get(
                    "/student/get-class-group-base-selective-subject-list/" +
                        this.academic_class_id +
                        "/" +
                        academic_group +
                        "/" +
                        this.academic_year_id +
                        "/" +
                        this.academic_department_id
                )
                .then(({ data }) => {
                    console.log(data);
                    this.ReligionSubjectList = data[0];
                    this.SelectiveCompulsorySubjectList = data[1];
                 //   this.CompulsorySubjectList=data[0];
                    this.OptionalSubjectList = data[2];
                    this.MarkinglessSubjectList = data[3];

                    this.compulsory_subject_limit = data[4];
                    this.optional_subject_limit = data[5];


                    if(this.compulsory_subject_limit>1){
                       
                        if (typeof this.form.selective_compulsory_subject_ids === "number") {
                        
                            const sele_com_sub_ids=[];
                            this.SelectiveCompulsorySubjectList.forEach(element => {
                                if(element.id == this.form.selective_compulsory_subject_ids){
                                    sele_com_sub_ids.push(element.id);
                                }
                            });
                            this.form.selective_compulsory_subject_ids=sele_com_sub_ids;
                        }else{
                            this.form.selective_compulsory_subject_ids = Array.isArray(this.form.selective_compulsory_subject_ids)
                                ? this.form.selective_compulsory_subject_ids
                                : [this.form.selective_compulsory_subject_ids];
                            
                        }

                      
                      
                     }
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {});
        },

        isObject(value) {
            return typeof value === "object" && value !== null && !Array.isArray(value);
          },

        // present address
        getPresentSiteCountry() {
            axios
                .get(window.routesH.route_site_country_list)
                .then(({ data }) => {
                    //console.log(data);
                    this.PresentCountryList = data;
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {});
        },

        presentCountryChange() {
            this.PresentDivisionList = [];
            this.PresentDistrictList = [];
            this.PresentThanaList = [];

            if (this.form.present_country_id) {
                this.presentDivisionLoadingImg = true;
                axios
                    .get(
                        "/division/get-division-list/" +
                            this.form.present_country_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentDivisionList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentDivisionLoadingImg = false));
            }
        },

        presentDivisionChange() {
            this.PresentDistrictList = [];
            this.PresentThanaList = [];

            if (this.form.present_division_id) {
                this.presentDistrictLoadingImg = true;
                axios
                    .get(
                        "/district/get-district-list/" +
                            this.form.present_division_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentDistrictList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentDistrictLoadingImg = false));
            }
        },

        presentDistrictChange() {
            this.PresentThanaList = [];

            if (this.form.present_district_id) {
                this.presentThanaLoadingImg = true;
                axios
                    .get(
                        "/thana/get-thana-list/" + this.form.present_district_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentThanaList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentThanaLoadingImg = false));
            }
        },

        // Permanent address
        getPermanentSiteCountry() {
            // this.PermanentCountryList = this.PresentCountryList;
            axios
                .get(window.routesH.route_site_country_list)
                .then(({ data }) => {
                    //console.log(data);
                    this.PermanentCountryList = data;
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {});
        },

        permanentCountryChange() {
            this.PermanentDivisionList = [];
            this.PermanentDistrictList = [];
            this.PermanentThanaList = [];

            if (this.form.permanent_country_id) {
                this.permanentDivisionLoadingImg = true;
                axios
                    .get(
                        "/division/get-division-list/" +
                            this.form.permanent_country_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentDivisionList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.permanentDivisionLoadingImg = false));
            }
        },

        permanentDivisionChange() {
            this.PermanentDistrictList = [];
            this.PermanentThanaList = [];

            if (this.form.permanent_division_id) {
                this.permanentDistrictLoadingImg = true;
                axios
                    .get(
                        "/district/get-district-list/" +
                            this.form.permanent_division_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentDistrictList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.permanentDistrictLoadingImg = false));
            }
        },

        permanentDistrictChange() {
            this.PermanentThanaList = [];

            if (this.form.permanent_district_id) {
                this.permanentThanaLoadingImg = true;
                axios
                    .get(
                        "/thana/get-thana-list/" +
                            this.form.permanent_district_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentThanaList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.permanentThanaLoadingImg = false));
            }
        },

        permanentThanaChange() {
            if (this.form.permanent_thana_id != this.form.present_thana_id) {
                this.sameAddressSelect = false;
            }
        },

        SameAddress() {
            this.form.permanent_country_id = "";
            this.form.permanent_division_id = "";
            this.form.permanent_district_id = "";
            this.form.permanent_thana_id = "";
            this.form.PermanentAddress = "";
            // console.log(this.sameAddressSelect);

            if (this.sameAddressSelect) {
                this.form.permanent_country_id = this.form.present_country_id;
                this.permanentCountryChange();
                this.form.permanent_division_id = this.form.present_division_id;
                this.permanentDivisionChange();
                this.form.permanent_district_id = this.form.present_district_id;
                this.permanentDistrictChange();
                this.form.permanent_thana_id = this.form.present_thana_id;
                this.form.permanent_address = this.form.present_address;
            }
        },

        StudentEditFromList(a) {
            this.studentDetailsShow = false;

            if (a.std_detail == true) {
                this.studentDetailsShow = true;
                this.student_for_edit_id = a.std_history_id;
                window.open(
                    "/student/view" +
                        "/" +
                        a.std_history_id,
                    "_blank"
                );
            }

            if (a.std_edit == true) {

                this.studentListShow = false;
                this.studentFormShow = true;
                this.StdListBtnShow = true;
                this.StdFormBtnShow = false;

                this.gettingStudentForEditImg = true;
                this.student_for_edit_id = a.std_history_id;

                this.editMode = true;
                this.PrimaryInfoShowHide = true;

                // this.blankWithOutForm();
                this.form.reset();


                axios
                    .get(
                        "/student/get-student-detail-for-edit/" +
                            this.student_for_edit_id
                    )
                    .then(({ data }) => {


                        this.academic_version_id = data.academic_version_id;
                        this.academic_year_id = data.academic_year_id;
                        this.academic_shift_id = data.academic_shift_id;
                        this.ChangeVersionYear();
                        if (data.academic_department_id) {
                            this.academic_department_id =
                                data.academic_department_id;
                            this.onChangeDepartment();
                        }
                        this.academic_class_id = data.academic_class_id;
                        this.changeClass();
                        this.academic_session_id = data.academic_session_id;
                        this.site_batch_detail_id = data.site_batch_detail_id;
                        this.academic_class_group_id = data.academic_class_group_id;
                        this.academic_section_id = data.academic_section_id;
                        this.academic_student_category_id = data.academic_student_category_id;
                        this.academic_student_type_id = data.academic_student_type_id;
                        this.academic_student_admission_type_id = data.academic_student_admission_type_id;

                        this.whenYearClassSelect = true;

                        this.ClassBaseGroupSection();

                        this.form.fill(data);
                        this.form.student_contact_number=data.contact_number;

                        this.form.student_image = data.latest_photo
                            ? data.latest_photo.name
                            : null;


                        if(data.selective_copulsory_subject_limit){
                            if(data.selective_copulsory_subject_limit==1){

                                if(data.selective_compulsory_subject_ids[1].length>1){
                                    this.form.selective_compulsory_subject_ids = data.selective_compulsory_subject_ids[1]
                                    ? data.selective_compulsory_subject_ids[1].length>1?data.selective_compulsory_subject_ids[1][0]:data.selective_compulsory_subject_ids[1]
                                    : [];
                                }else{
                                    this.form.selective_compulsory_subject_ids = data.selective_compulsory_subject_ids[1]
                                    ? data.selective_compulsory_subject_ids[1].length==1?data.selective_compulsory_subject_ids[1][0]:data.selective_compulsory_subject_ids[1]
                                    : [];
                                }

                            }else{
                                this.form.selective_compulsory_subject_ids = data.selective_compulsory_subject_ids[1].length
                                ? data.selective_compulsory_subject_ids[1]:[];
                            }
                        }else{
                            if(data.selective_compulsory_subject_ids[1].length>1){
                                this.form.selective_compulsory_subject_ids = data.selective_compulsory_subject_ids[1]
                                ? data.selective_compulsory_subject_ids[1].length>1?data.selective_compulsory_subject_ids[1][0]:data.selective_compulsory_subject_ids[1]
                                : [];
                            }else{
                                this.form.selective_compulsory_subject_ids = data.selective_compulsory_subject_ids[1]
                                ? data.selective_compulsory_subject_ids[1].length==1?data.selective_compulsory_subject_ids[1][0]:data.selective_compulsory_subject_ids[1]
                                : [];
                            }
                        }

                        /// optional subject limit conditon
                        if(data.optional_subject_limit){
                            if(data.optional_subject_limit==1){

                                if(data.optional_subject_ids[1].length>1){

                                    this.form.optional_subject_ids = data.optional_subject_ids[1]
                                    ? data.optional_subject_ids[1].length>1?data.optional_subject_ids[1][0]:data.optional_subject_ids[1]
                                    : [];
                                }else{
                                    this.form.optional_subject_ids = data.optional_subject_ids[1]
                                    ? data.optional_subject_ids[1].length==1?data.optional_subject_ids[1][0]:data.optional_subject_ids[1]
                                    : [];
                                }

                            }else{
                                this.form.optional_subject_ids = data.optional_subject_ids[1]?data.optional_subject_ids[1]:[];
                            }
                        }else{

                            if(data.optional_subject_ids[1].length>1){

                                this.form.optional_subject_ids = data.optional_subject_ids[1]
                                ? data.optional_subject_ids[1].length>1?data.optional_subject_ids[1][0]:data.optional_subject_ids[1]
                                : [];
                            }else{
                                this.form.optional_subject_ids = data.optional_subject_ids[1]
                                ? data.optional_subject_ids[1].length==1?data.optional_subject_ids[1][0]:data.optional_subject_ids[1]
                                : [];
                            }
                        }

                        this.form.selective_markingless_subject_ids = data
                            .selective_markingless_subject_ids[1]
                            ? data.selective_markingless_subject_ids[1].length==1?data.selective_markingless_subject_ids[1][0]:data.selective_markingless_subject_ids[1]
                            : [];




                        if (
                            data.father_email ||
                            data.father_contact_number ||
                            data.father_occupation_id ||
                            data.father_yearly_income ||
                            data.mother_email ||
                            data.mother_contact_number ||
                            data.mother_occupation_id ||
                            data.mother_yearly_income
                        ) {
                            this.GurdianInfoShowHide = true;
                        }

                        if (
                            data.birth_certificate_no ||
                            data.nid_number ||
                            data.passport_no ||
                            data.email ||
                            data.emergency_contact
                        ) {
                            this.CommunicationInfoShowHide = true;
                        }

                        if (data.previous_institute_name) {
                            this.PreviousInfoHideShow = true;
                        }

                        if (data.local_gurdian_name) {
                            this.LocalGurdianHideShow = true;
                        }

                        if (data.present_country_id) {
                            this.AddressShowHide = true;
                            this.getPresentSiteCountry();
                            this.presentCountryChange();
                            this.presentDivisionChange();
                            this.presentDistrictChange();
                        }

                        if (data.permanent_country_id) {
                            this.AddressShowHide = true;
                            this.getPermanentSiteCountry();
                            this.permanentCountryChange();
                            this.permanentDivisionChange();
                            this.permanentDistrictChange();
                        }

                        this.student_history_id = data.student_history_id;
                        this.form.present_address = data.address;

                        this.academic_class_group_id = data.academic_class_group_id
                            ? data.academic_class_group_id
                            : "";
                        if (data.academic_class_group_id) {
                            this.academicGroupChange();
                        }

                        this.academic_section_id = data.academic_section_id;

                        this.academic_student_category_id =
                            data.academic_student_category_id;

                        this.academic_session_id = data.academic_session_id;
                        this.academic_student_type_id =
                            data.academic_student_type_id;
                        this.academic_student_admission_type_id =
                            data.academic_student_admission_type_id;

                        this.form.previous_marks = data.previous_exam_mark;
                        this.form.student_birth_certificate_no =
                            data.birth_certificate_no;
                        this.form.student_national_id = data.nid_number;
                        this.form.student_email_id = data.email;
                        this.form.student_mobile_number = data.contact_number;
                        this.form.student_passport_number = data.passport_no;
                        this.form.student_emergency_contact_number =
                            data.emergency_contact;
                        this.form.relation_id =
                            data.guardian_student_relation_id;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => {
                        this.gettingStudentForEditImg = false;
                    });
            }
        }
    },

    created() {
        this.getSiteYearShiftClassSessionVersionConditionList();
    }
};
