import Vue from "vue";
window.Vue = Vue;

require("./bootstrap");

/* import Vuesax from "vuesax";
import "vuesax/dist/vuesax.css";
Vue.use(Vuesax); */

import "material-icons/iconfont/material-icons.css";

require("promise.prototype.finally").shim();

import { Form, HasError, AlertError } from "vform";
window.Form = Form;

// import VueCtkDateTimePicker from "vue-ctk-date-time-picker";
const VueCtkDateTimePicker = () => import("vue-ctk-date-time-picker");
Vue.component("VueCtkDateTimePicker", VueCtkDateTimePicker);
import "vue-ctk-date-time-picker/dist/vue-ctk-date-time-picker.css";

Vue.component(HasError.name, HasError);
Vue.component(AlertError.name, AlertError);

Vue.component("pagination", require("laravel-vue-pagination"));
//sweet alert 2

//globally
import columnSortable from "vue-column-sortable";
Vue.use(columnSortable);

import CKEditor from "ckeditor4-vue";

import vSelect from "vue-select";
Vue.component("v-select", vSelect);

import swal from "sweetalert2";
window.swal = swal;
const toast = swal.mixin({
    toast: true,
    position: "top-end",
    showConfirmButton: false,
    timer: 15000
});
window.toast = toast;

//https://hamed-ehtesham.github.io/pretty-checkbox-vue/#installation
// import { createApp } from 'vue'

// import App from './App.vue'

 import  VueHtmlToPaper from './plugins/VueHtmlToPaper'

 const options = {
    name: '_blank',
    specs: [
      'fullscreen=yes',
      'titlebar=yes',
      'scrollbars=yes'
    ],
    // styles: [
    //   'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css',
    //   'https://unpkg.com/kidlat-css/css/kidlat.css'
    // ],
    timeout: 1000, // default timeout before the print window appears
    autoClose: true, // if false, the window will not close after printing
    windowTitle: window.document.title, // override the window title
  }

  Vue.use(VueHtmlToPaper, options);

  // or, using the defaults with no stylesheet
  //Vue.use(VueHtmlToPaper);

// let app=createApp(App);

Vue.use(VueHtmlToPaper)

 //app.mount('#app')
//////////////

import PrettyCheckbox from "pretty-checkbox-vue";
Vue.use(PrettyCheckbox);

import "@/helpers/filters";
//vue lang
import VueInternationalization from "vue-i18n";
import Locale from "./vue-i18n-locales.generated";

Vue.use(VueInternationalization);

const lang = document.documentElement.lang.substr(0, 2);
// or however you determine your current app locale
//console.log("lang:" + lang);

// import Vue from 'vue';
// import VueHtmlToPaper from 'vue-html-to-paper';

// Vue.use(VueHtmlToPaper, options);
// // or using the defaults with no stylesheet
// Vue.use(VueHtmlToPaper);

const i18n = new VueInternationalization({
    locale: lang,
    messages: Locale
});
Vue.component(
    "admin-breadcrumb-component",
    require("./components/logged-common/BreadCrumb.vue").default
);
Vue.component(
    "passport-clients",
    require("./components/passport/Clients.vue").default
);
Vue.component(
    "notification-wrapper-component",
    require("@/components/logged-common/NotificationWrapperComponent.vue")
        .default
);

/* Vue.component(
    "passport-authorized-clients",
    require("./components/passport/AuthorizedClients.vue").default
);

Vue.component(
    "passport-personal-access-tokens",
    require("./components/passport/PersonalAccessTokens.vue").default
); */

//global component

// dash board
/*
Vue.component(
    "edu-global-site-version-year-shift-class-group-section",
    require("./components/edu/global/SiteVersionYearShiftDeptClassGroupSectionComponent.vue").default
);

Vue.component(
    "edu-company-company-list",
    require("./components/edu/company/CompanyComponent.vue").default
);

Vue.component(
    "logged-common-user-profile-pic",
    require("./components/logged-common/profilePicComponent.vue").default
);

Vue.component(
    "logged-common-view-all-notification-component",
    require("./components/logged-common/AllNotificationsComponent.vue")
);

Vue.component(
    "logged-common-user-setting",
    require("./components/logged-common/UserSettingComponent.vue")
);

Vue.component(
    "dashboard-site-latest-employee-attendance-list",
    require("./components/dashboard/site/LatestEmployeeAttendanceComponent.vue")
);
Vue.component(
    "dashboard-site-latest-student-attendance-list",
    require("./components/dashboard/site/latestStudentAttendanceListComponent.vue")
);

Vue.component(
    "dashboard-site-employee-attendance-graph",
    require("./components/dashboard/site/dashboardEmployeeAttendanceGraphComponent.vue")
);

Vue.component(
    "logged-common-user-setting",
    require("./components/logged-common/UserSettingComponent.vue")
);
//===================HOLIDAYS============================

Vue.component(
    "holidays-component",
    require("./components/edu/holiday/holidaysComponent.vue")
);

//==============Site Routine ---
Vue.component(
    "edu-site-routine-component",
    require("./components/edu/site/routine/MasterComponent.vue")
);

// EDU INTERNAL-..------------------------------------START---------------------
Vue.component(
    "edu-fetch-log-master",
    require("./components/edu/log/masterComponent.vue")
);

Vue.component(
    "edu-dashboard-palette-list",
    require("./components/edu/dashboard-palette/DashboardPaletteComponent.vue")
);
Vue.component(
    "edu-site-group-component",
    require("./components/edu/site_group/SiteGroupComponent.vue")
);
Vue.component(
    "edu-users-permission",
    require("./components/edu/users/PermissionComponent.vue")
);
Vue.component(
    "edu-role-list",
    require("./components/edu/role/EduRoleComponent.vue")
);

Vue.component(
    "edu-users-list",
    require("./components/edu/users/EduUserComponent.vue")
);

//site memebership
Vue.component(
    "edu-site-membership",
    require("./components/edu/site-membership/SiteMembershipComponent.vue")
);

Vue.component(
    "edu-menu-master-component",
    require("./components/edu/menu/masterComponent.vue")
);
Vue.component(
    "menu-using-route-attachment",
    require("./components/edu/menu/MenuUsingRouteAttachmentComponent.vue")
);
Vue.component(
    "edu-package",
    require("./components/edu/package/EduPackageComponent.vue")
);
// ==================fee=========================
Vue.component(
    "academic-fee-head-list-component",
    require("./components/academic/academicFeeHeadComponent.vue")
);
Vue.component(
    "academic-fee-sub-head-list-component",
    require("./components/academic/AcademicFeeSubHeadComponent.vue")
);
Vue.component(
    "academic-fee-group-list-component",
    require("./components/academic/AcademicFeeGroupComponent.vue")
);
Vue.component(
    "academic-admission-fee-type-view",
    require("./components/academic/AcademicAdmissionFeeTypeComponent.vue")
);
Vue.component(
    "academic-site-waiver-type-view-component",
    require("./components/site/SiteWaiverTypeComponent.vue")
);
Vue.component(
    "site-student-offer-type-view-component",
    require("./components/site/SiteStudentOfferTypeComponent.vue")
);
// ==================invoice=========================
Vue.component(
    "edu-site-monitor-master-component",
    require("./components/edu/site-monitor/MasterComponent.vue")
);

//edu-company

Vue.component(
    "edu-company-company-list",
    require("./components/edu/company/CompanyComponent.vue")
);

// EDU INTERNAL-------------------------------------END-------------------

Vue.component("passport-clients", require("./components/passport/Clients.vue"));

Vue.component(
    "passport-authorized-clients",
    require("./components/passport/AuthorizedClients.vue")
);

Vue.component(
    "passport-personal-access-tokens",
    require("./components/passport/PersonalAccessTokens.vue")
);
Vue.component(
    "site-group-fee-single-student-payment-component",
    require("./components/site_group/fee/SiteGroupFeeSingleStudentPaymentComponent.vue")
);

//Assign Extra Permission

Vue.component(
    "edu-user-assign-extra-permission",
    require("./components/edu/users/AssignExtraPermissionComponent.vue")
);

//LARAVEL PASSPORT------------------------------------END-------------------------

Vue.component(
    "example-component",
    require("./components/ExampleComponent.vue")
);
Vue.component(
    "timetable-component",
    require("./components/TimetableComponent.vue")
);

Vue.component(
    "sub-module-attachment-component",
    require("./components/edu/module/SubModuleAttachmentComponent.vue")
);
Vue.component(
    "module-master-component",
    require("./components/edu/module/masterComponent.vue")
);

Vue.component(
    "module-component",
    require("./components/edu/module/ModuleAttachmentComponent.vue")
);

Vue.component(
    "academic-subject-component",
    require("./components/academic/AcademicSubjectComponent.vue")
);
Vue.component(
    "academic-subject-condition-component",
    require("./components/academic/AcademicSubjectConditionComponent.vue")
);
Vue.component(
    "academic-fee-component",
    require("./components/academic/AcademicFeeComponent.vue")
);
Vue.component(
    "academic-section-component",
    require("./components/academic/AcademicSectionComponent.vue")
);
Vue.component(
    "academic-group-detail-component",
    require("./components/AcademicGroupDetailComponent.vue")
);
Vue.component(
    "academic-session-type-component",
    require("./components/academic/AcademicSessionTypeComponent.vue")
);

Vue.component(
    "site-info-component",
    require("./components/edu/site/SiteInfoComponent.vue")
);

Vue.component(
    "academic-group-list-tab-component",
    require("./components/site/AcademicGroupListTabComponent.vue")
);
Vue.component(
    "site-academic-period-type-setting-component",
    require("./components/site/academic/PeriodTypeSettingComponent.vue")
);

Vue.component(
    "site-group-controlling-component",
    require("./components/site_group/SiteGroupControllingComponent.vue")
);

Vue.component(
    "global-academic-calendar-master-view",
    require("./components/edu/GlobalAcademicCalendar/academicCalenderMasterComponent.vue")
); */

import { handleAxiosError } from '../js/src/utils/errorHandler'

Vue.prototype.$handleAxiosError = handleAxiosError;

import store from "./store/store";
import router from "./routes/routes";

const edu = new Vue({
    i18n,
    router,
    store
}).$mount("#app");
