import Vue from "vue";
/* ====Global filter START =========================*/

Vue.filter("activeInactive", function(value) {
    if (value == 1) {
        return "Active";
    } else {
        return "Inactive";
    }
});
Vue.filter("yesNo", function(value) {
    if (value == 1) {
        return "Yes";
    } else {
        return "No";
    }
});

//import moment from "moment";

import moment from "moment";
window.moment = moment;
let lang = document.documentElement.lang.substr(0, 2);
moment.locale(lang);

Vue.filter("formatTime", function(value) {
    if (value) {
        return moment(String(value), ["HH:mm"]).format("hh:mm A");
    }
});

Vue.filter("formatTimeSec", function(value) {
    if (value) {
        return moment(String(value), ["HH:mm:ss"]).format("hh:mm:ss A");
    }
    return "";
});
Vue.filter("formatDateTime", function(value) {
    //console.log(value);

    if (value) {
        return moment(String(value)).format("DD MMMM YYYY hh:mm A");
    }
});
Vue.filter("formatDayMonth", function(value) {
    if (value) {
        return moment(String(value), ["dd:mm"]).format("dd:mm");
    }
});
Vue.filter("formatMinDiff", function(stTime, endTime) {
    if (stTime && endTime) {
        var startTime = moment(stTime, "hh:mm:ss");
        var endTime = moment(endTime, "hh:mm:ss");
        var mins = moment
            .utc(
                moment(endTime, "hh:mm:ss").diff(moment(startTime, "hh:mm:ss"))
            )
            .format("mm");
        return mins + " mins";
    }
});
Vue.filter("formatHourDiff", function(stTime, endTime) {
    if (stTime && endTime) {
        // start time and end time
        var startTime = moment(stTime, "HH:mm:ss a");
        var endTime = moment(endTime, "HH:mm:ss a");

        // calculate total duration
        var duration = moment.duration(endTime.diff(startTime));

        // duration in hours
        var hours = parseInt(duration.asHours());

        // duration in minutes
        var minutes = parseInt(duration.asMinutes()) % 60;
        return hours + " hour " + minutes + " mins.";
    }
});
Vue.filter("formatDate", function(value) {
    //console.log(value);
    if (value) {
        return moment(String(value)).format("DD MMMM YYYY");
    }
});
Vue.filter("formatDay", function(value) {
    //console.log(value);
    if (value) {
        return moment(String(value)).format("DD");
    }
});
Vue.filter("formatMonth", function(value) {
    //console.log(value);
    if (value) {
        return moment(String(value)).format("MMMM");
    }
});
//capitalize --- apple->Apple
Vue.filter("capitalize", function(value) {
    if (!value) return "";
    return value.charAt(0).toUpperCase() + value.slice(1);
});

//ordinal number
Vue.filter("ordinal", function(n) {
    var s = ["th", "st", "nd", "rd"],
        v = n % 100;
    return n + (s[(v - 20) % 10] || s[v] || s[0]);
});

//remove html tags
Vue.filter("striphtml", function(value) {
    var div = document.createElement("div");
    div.innerHTML = value;
    var text = div.textContent || div.innerText || "";
    return text;
});

Vue.filter("currency", function(value) {
    return "৳ " + parseFloat(value).toFixed(2);
});
Vue.filter("round", function(value) {
    return parseFloat(value).toFixed(0);
});
Vue.filter("floor", function(value) {
    return Math.floor(value);
});

// YourVueComponent.vue or main.js

Vue.filter('translateData', function (number,lang) {
    // Define the mapping of English numbers to Bangla numbers
    if(lang=='bn'){
        const numberMap = {
            '-': '-',
            '+': '+',
            '0': '০',
            '1': '১',
            '2': '২',
            '3': '৩',
            '4': '৪',
            '5': '৫',
            '6': '৬',
            '7': '৭',
            '8': '৮',
            '9': '৯',
        }
        const translatedNumber = String(number)
        .split('')
        .map(digit => numberMap[digit] || digit)
        .join('');
    
      return translatedNumber;
          
    }else{
        const numberMap = {
            '-': '-',
            '+': '+',
            '0': '0',
            '1': '1',
            '2': '2',
            '3': '3',
            '4': '4',
            '5': '5',
            '6': '6',
            '7': '7',
            '8': '8',
            '9': '9',
        }
        const translatedNumber = String(number)
        .split('')
        .map(digit => numberMap[digit] || digit)
        .join('');
    
      return translatedNumber;
    }
  
    // Convert each digit in the number

  });
  
