export default [
    {
        name: "edu-featured-list",
        path: "/featured/featured-list",
        component: () => import("@/components/edu/FeaturedListComponent"),
        meta: {
            breadcrumb: [
                { title: "featured" },
                { title: "featured", active: true }
            ],
            pageTitle: "featured"
        }
    },

    {
        name: "edu-company-company-list",
        path: "/edu/company/list",
        component: () => import("@/components/edu/company/CompanyComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Company", active: true }
            ],
            pageTitle: "Company"
        }
    },
    {
        name: "edu-menu-master",
        path: "/menu",
        component: () => import("@/components/edu/menu/masterComponent"),

        children: [
            {
                name: "edu-menu-list",
                path: "list",
                component: () => import("@/components/edu/menu/MenuComponent"),
                meta: {
                    breadcrumb: [
                        { title: "Core Setup" },
                        { title: "Menu" },
                        { title: "Menus", active: true }
                    ],
                    pageTitle: "Menus"
                }
            },
            {
                name: "edu-menu-menu-using-route",
                path: "using-route-attachment",
                component: () =>
                    import(
                        "@/components/edu/menu/MenuUsingRouteAttachmentComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Core Setup" },
                        { title: "Menu" },
                        { title: "Menus Using", active: true }
                    ],
                    pageTitle: "Menus Using"
                }
            }
        ]
    },
    {
        name: "edu-dashboard-palette-list",
        path: "/edu/dashboard-palette/list",
        component: () =>
            import(
                "@/components/edu/dashboard-palette/DashboardPaletteComponent.vue"
            ),

        meta: {
            breadcrumb: [{ title: "Edu dashboard list" }],
            pageTitle: "Edu dashboard list"
        }
    },
    {
        name: "edu-site-attendance-log-view",
        path: "/edu/fetch/edu-log-view",
        component: () => import("@/components/edu/log/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Edu Log", active: true }
            ],
            pageTitle: "Edu Log"
        }
    },

    {
        name: "global-academic-calendar-master-view",
        path: "/edu/global-calendar/index",
        component: () => import("@/components/edu/GlobalAcademicCalendar/academicCalendarEventListComponent"),
        meta: {
            breadcrumb: [
                { title: "Global Academic Calendar" },
                { title: "Global Academic Calendar", active: true }
            ],
            pageTitle: "Global Academic Calendar"
        }

  },

    {
        name: "edu-site-membership",
        path: "/edu/site-membership/list",
        component: () =>
            import("@/components/edu/site-membership/SiteMembershipComponent"),
        meta: {
            breadcrumb: [
                { title: "Office Manager" },
                { title: "Institution Membership", active: true }
            ],
            pageTitle: "Institution Membership"
        }
    },
    {
        name: "edu-site-impersonate",
        path: "/edu/site/impersonate",
        component: () =>
            import("@/components/edu/site/SiteImpersonateComponent"),
        meta: {
            breadcrumb: [{ title: "Site Impersonate", active: true }],
            pageTitle: "Site Impersonate"
        }
    },
    {
        name: "edu-site-list",
        path: "/edu/site/list",
        component: () => import("@/components/edu/site/SiteListComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup", active: true },
                { title: "Institution Single", active: true },
                { title: "Institution List", active: true }
            ],
            pageTitle: "Institution List"
        }
    },
    {
        name: "edu-site-new",
        path: "/edu/site/new",
        component: () => import("@/components/edu/site/NewSiteComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup", active: true },
                { title: "Institution Single", active: true },
                { title: "Institution New", active: true }
            ],
            pageTitle: "Institution New"
        }
    },
    {
        name: "edu-site-edit",
        path: "/edu/site/edit/:id",
        props: true,
        component: () => import("@/components/edu/site/NewSiteComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup", active: true },
                { title: "Institution Single", active: true },
                { title: "Institution Edit", active: true }
            ],
            pageTitle: "Institution Edit"
        }
    },
    {
        name: "edu-site-academic-group-setting",
        path: "/edu/site/academic-group/:site_id",
        props: true,
        component: () => import("@/components/edu/site/AcademicGroupSetting"),
        meta: {
            breadcrumb: [{ title: "Site List", active: true }],
            pageTitle: "Site Academic Group Edit"
        }
    },
    {
        name: "edu-site-academic-group-details",
        path: "/edu/site/academic/details/:id",
        component: () => import("@/components/edu/site/AcademicGroupComponent"),
        meta: {
            breadcrumb: [{ title: "Academic Group Details", active: true }],
            pageTitle: "Academic Group Details"
        }
    },

    {
        name: "edu-newsite-application-list",
        path: "/edu/site/application/list",
        component: () =>
            import("@/components/edu/site/application/ListComponent"),
        meta: {
            breadcrumb: [{ title: "Site Application List", active: true }],
            pageTitle: "Site Application List"
        }
    },

    {
        name: "edu-newsite-application-approve",
        path: "/edu/site/application/approve/:app_id",
        props: true,
        component: () => import("@/components/edu/site/NewSiteComponent"),
        meta: {
            breadcrumb: [{ title: "New Site Approve", active: true }],
            pageTitle: "New Site Approve"
        }
    },

    {
        name: "edu-newsite-application-edit",
        path: "/edu/site/application/edit/:id",
        props: true,
        component: () =>
            import("@/components/web-site/pages/edu/NewSiteApplication.vue"),
        meta: {
            breadcrumb: [{ title: "New Site Application Edit", active: true }],
            pageTitle: "New Site Application Edit"
        }
    },

    {
        name: "edu-invoice-master",
        path: "/edu",
        component: () => import("@/components/edu/invoice/MasterComponent"),
        children: [
            {
                name: "edu-site-invoice-list",
                path: "invoice/master",
                component: () =>
                    import("@/components/edu/invoice/InvoiceListComponent"),
                meta: {
                    breadcrumb: [{ title: "Invoice", active: true }],
                    pageTitle: "Invoice"
                }
            },
            {
                name: "edu-site-delivery-challan-list",
                path: "challan/master",
                component: () =>
                    import("@/components/edu/invoice/DeliveryChallanListComponent"),
                meta: {
                    breadcrumb: [{ title: "Delivery challan", active: true }],
                    pageTitle: "Delivery challan"
                }
            },
            {
                name: "edu-site-regular-site-invoice-list",
                path: "reguler-site/master",
                component: () =>
                    import("@/components/edu/invoice/RegularSiteInvoiceCreateComponent"),
                meta: {
                    breadcrumb: [{ title: "Delivery challan", active: true }],
                    pageTitle: "Delivery challan"
                }
            },
            {
                name: "edu-site-regular-site-head-wise-report-list",
                path: "reguler-site/master2",
                component: () =>
                    import("@/components/edu/invoice/RegularSiteHeadWiseReportComponent"),
                meta: {
                    breadcrumb: [{ title: "Delivery challan", active: true }],
                    pageTitle: "Delivery challan"
                }
            },
            {
                name: "edu-site-invoice-create",
                path: "invoice/create",
                component: () =>
                    import("@/components/edu/invoice/NewInvoiceComponent"),
                meta: {
                    breadcrumb: [
                        { title: "Office Manager" },
                        { title: "Site Monitor" },
                        { title: "Invoice Create", active: true }
                    ],
                    pageTitle: "Invoice Create"
                }
            },
            {
                name: "edu-site-Challan-create",
                path: "challan/create",
                component: () =>
                    import("@/components/edu/challan/NewChallanComponent"),
                meta: {
                    breadcrumb: [
                        { title: "Office Manager" },
                        { title: "Site Monitor" },
                        { title: "challan Create", active: true }
                    ],
                    pageTitle: "challan Create"
                }
            },
            {
                name: "edu-site-challan-edit",
                path: "challan/edit/:id",
                props: true,
                component: () =>
                    import("@/components/edu/challan/NewChallanComponent"),
                meta: {
                    breadcrumb: [
                        { title: "Office Manager" },
                        { title: "Site Monitor" },
                        { title: "Invoice Create", active: true }
                    ],
                    pageTitle: "Invoice Create"
                }
            },

            {
                name: "edu-site-invoice-edit",
                path: "invoice/edit/:id",
                props: true,
                component: () =>
                    import("@/components/edu/invoice/NewInvoiceComponent"),
                meta: {
                    breadcrumb: [
                        { title: "Office Manager" },
                        { title: "Site Monitor" },
                        { title: "Invoice Create", active: true }
                    ],
                    pageTitle: "Invoice Create"
                }
            },
            {
                name: "edu-site-monitory-student-id-card",
                path: "student-id-card",
                component: () =>
                    import("@/components/edu/monitor/StudentCardListComponent"),
                meta: {
                    breadcrumb: [
                        { title: "Office Manager" },
                        { title: "Site Monitor" },
                        { title: "Student ID Card", active: true }
                    ],
                    pageTitle: "Student ID Card"
                }
            }
        ]
    },
    {
        name: "module-master-component",
        path: "/sub-module/attached-list",
        component: () => import("@/components/edu/module/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Module & Package" },
                { title: "Sub Module Attach List", active: true }
            ],
            pageTitle: "Sub Module Attach List"
        }
    },
    {
        name: "module-component",
        path: "/module/attachment-list",
        component: () =>
            import("@/components/edu/module/ModuleAttachmentComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Module & Package" },
                { title: "Module List", active: true }
            ],
            pageTitle: "Module List"
        }
    },
    {
        name: "edu-package",
        path: "/package/attached-list",
        component: () => import("@/components/edu/package/EduPackageComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Module & Package" },
                { title: "Package List", active: true }
            ],
            pageTitle: "Package List"
        }
    },
    {
        name: "edu-site-group-master",
        path: "/edu/site-group/list",
        component: () =>
            import("@/components/edu/site_group/SiteGroupComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Institution Group" },
                { title: "Group List", active: true }
            ],
            pageTitle: "Group List"
        }
    },
    {
        name: "edu-site-group-new-site",
        path: "/edu/site-group/new-site/:gr_id",
        props: true,
        component: () => import("@/components/edu/site/NewSiteComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Institution Group" },
                { title: "New Site", active: true }
            ],
            pageTitle: "New Site"
        }
    },

    {
        name: "edu-passport-master",
        path: "/laravel-passport",
        component: () => import("@/components/edu/passport/PassportComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Passport", active: true }
            ],
            pageTitle: "Passport"
        }
    },
    {
        name: "edu-academic-fee-head",
        path: "/academic/academic-fee-head/view",
        component: () =>
            import("@/components/academic/AcademicFeeHeadComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Fee Settings" },
                { title: "Fee Head", active: true }
            ],
            pageTitle: "Fee Head"
        }
    },
    {
        name: "edu-academic-fee-sub-head",
        path: "/academic/academic-fee-sub-head/view",
        component: () =>
            import("@/components/academic/AcademicFeeSubHeadComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Fee Settings" },
                { title: "Fee Sub Head", active: true }
            ],
            pageTitle: "Fee Sub Head"
        }
    },
    {
        name: "edu-academic-fee-group",
        path: "/academic/academic-fee-group/view",
        component: () =>
            import("@/components/academic/AcademicFeeGroupComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Fee Settings" },
                { title: "Fee Group", active: true }
            ],
            pageTitle: "Fee Group"
        }
    },
    {
        name: "edu-academic-waiver-type",
        path: "/academic/waiver-type/view",
        component: () =>
            import("@/components/academic/SiteWaiverTypeComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Fee Settings" },
                { title: "Waiver Type", active: true }
            ],
            pageTitle: "Waiver Type"
        }
    },
    {
        name: "edu-academic-student-offer-type",
        path: "/academic/student-offer-type/view",
        component: () =>
            import("@/components/academic/SiteStudentOfferTypeComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Fee Settings" },
                { title: "Offer Type", active: true }
            ],
            pageTitle: "Offer Type"
        }
    },
    // {
    //     name: "edu-company-page",
    //     path: "/edu/company/list",
    //     component: () => import("@/components/edu/company/CompanyComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Core Setup" },
    //             { title: "Company", active: true }
    //         ],
    //         pageTitle: "Company"
    //     }
    // },
    {
        name: "edu-academic-class-list",
        path: "/academic/class/list",
        component: () =>
            import("@/components/academic/class/ClassListComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Class", active: true }
            ],
            pageTitle: "Academic Class"
        }
    },
    {
        name: "edu-academic-class-new",
        path: "/academic/class/new",
        component: () =>
            import("@/components/academic/class/NewClassComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Class New", active: true }
            ],
            pageTitle: "Academic Class New"
        }
    },
    {
        name: "edu-academic-class-edit",
        path: "/academic/class/edit/:id",
        props: true,
        component: () =>
            import("@/components/academic/class/NewClassComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Class Edit", active: true }
            ],
            pageTitle: "Academic Class Edit"
        }
    },

    // academic session start
    {
        name: "edu-academic-session-new",
        path: "/academic/session/new",
        props: true,
        component: () =>
            import("@/components/academic/session/NewSessionComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Session Add", active: true }
            ],
            pageTitle: "Academic Session Add"
        }
    },

    {
        name: "edu-academic-session-list",
        path: "/academic/session/list",
        props: true,
        component: () =>
            import("@/components/academic/session/SessionListComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Session List", active: true }
            ],
            pageTitle: "Academic Session LIst"
        }
    },

    {
        name: "edu-academic-session-edit",
        path: "/academic/session/edit/:id",
        props: true,
        component: () =>
            import("@/components/academic/session/NewSessionComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Session Edit", active: true }
            ],
            pageTitle: "Academic Session Edit"
        }
    },

    // academic session end

    {
        name: "edu-role-list",
        path: "/edu/role/list",
        component: () => import("@/components/edu/role/EduRoleComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "User Role" },
                { title: "Role List", active: true }
            ],
            pageTitle: "Role List"
        }
    },

    {
        name: "edu-academic-class-group-list",
        path: "/academic/class-group/list",
        component: () =>
            import("@/components/academic/class-group/ListComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Class Group", active: true }
            ],
            pageTitle: "Academic Class Group"
        }
    },
    {
        name: "edu-academic-class-group-new",
        path: "/academic/class-group/new",
        component: () =>
            import("@/components/academic/class-group/NewComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Class Group New", active: true }
            ],
            pageTitle: "Academic Class Group New"
        }
    },
    {
        name: "edu-academic-class-group-edit",
        path: "/academic/class-group/edit/:id",
        props: true,
        component: () =>
            import("@/components/academic/class-group/NewComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Class Group Edit", active: true }
            ],
            pageTitle: "Academic Class Group Edit"
        }
    },
    {
        name: "edu-academic-subject-list",
        path: "/academic/subject/list",
        component: () =>
            import("@/components/academic/AcademicSubjectComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Subject", active: true }
            ],
            pageTitle: "Academic Subject"
        }
    },

    {
        name: "edu-academic-group-list",
        path: "/academic/group/list",
        component: () => import("@/components/academic/AcademicGroupComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Group", active: true }
            ],
            pageTitle: "Academic Group"
        }
    },

    {
        name: "academic-session-type",
        path: "/academic/academic-session-type/list",
        component: () =>
            import("@/components/academic/AcademicSessionTypeComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Session Type", active: true }
            ],
            pageTitle: "Academic Session Type"
        }
    },
    {
        name: "academic-assessment-setting-master",
        path: "/assessment/setting/assessment-setting-master",
        component: () =>
            import("@/components/assessment/setting/AcademicAssessmentSettingMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Assessment Setting", active: true }
            ],
            pageTitle: "Assessment Setting"
        }
    },
    {
        name: "assessment-result-setting-master",
        path: "/assessment/result-setting/assessment-result-setting-master",
        component: () =>
            import("@/components/assessment/result-setting/AssessmentResultSettingMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Result Setting", active: true }
            ],
            pageTitle: "Result Setting"
        }
    },
    // {
    //     name: "academic-assessment-expertise-form",
    //     path: "/assessment/assessment-expertise-list-form",
    //     component: () =>
    //         import("@/components/assessment/AcademicAssessmentExpertiseComponent"),
    //     meta: {
    //         breadcrumb: [
    //             { title: "Core Setup" },
    //             { title: "Academic" },
    //             { title: "Assessment Type", active: true }
    //         ],
    //         pageTitle: "Assessment Type"
    //     }
    // },
    {
        name: "routine-master",
        path: "/edu/site/routine/master",
        component: () =>
            import("@/components/edu/site/routine/MasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Home", url: "/" },
                { title: "Home", active: true }
            ],
            pageTitle: "Routine Master"
        }
    },
    {
        name: "holiday-view",
        path: "/edu/holiday/view",
        component: () => import("@/components/edu/holiday/holidaysComponent"),
        meta: {
            breadcrumb: [
                { title: "Time Table", url: "/" },
                { title: "Holidays", active: true }
            ],
            pageTitle: "Holiday View"
        }
    },
    {
        name: "site-group-impersonate",
        path: "/edu/site/impersonate-site-group",
        component: () =>
            import("@/components/edu/site_group/SiteGroupImpersonateComponent"),
        meta: {
            breadcrumb: [{ title: "Site Group Impersonate", active: true }],
            pageTitle: "Site Group Impersonate"
        }
    },
    {
        name: "academic-subject-condition",
        path: "/academic/subject-condition/list",
        component: () =>
            import("@/components/academic/AcademicSubjectConditionComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Academic" },
                { title: "Subject Condition", active: true }
            ],
            pageTitle: "Academic Subject Condition"
        }
    },

    {
        name: "user",
        path: "/edu/user/list",
        component: () => import("@/components/edu/users/EduUserComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "User Role" },
                { title: "User List", active: true }
            ],
            pageTitle: "User List"
        }
    },
    {
        name: "assign-extra-permission",
        path: "/edu/permission/edu-user-assign-extra-permission",
        component: () =>
            import("@/components/edu/users/AssignExtraPermissionComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "User Role" },
                { title: "Extra Permission", active: true }
            ],
            pageTitle: "Extra Permission"
        }
    },
    {
        name: "user-permission",
        path: "/edu/permission/assign",
        component: () => import("@/components/edu/users/PermissionComponent"),

        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "User Settings" },
                { title: "Assign User Permision", active: true }
            ],
            pageTitle: "Assign Permision"
        }
    },
    {
        name: "country",
        path: "/country/view",
        component: () => import("@/components/edu/CountryComponent"),

        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Location Settings" },
                { title: "Country", active: true }
            ],
            pageTitle: "Country"
        }
    },
    {
        name: "division",
        path: "/division/view",
        component: () => import("@/components/edu/DivisionComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Location Settings" },
                { title: "Division", active: true }
            ],
            pageTitle: "Division"
        }
    },
    {
        name: "district",
        path: "/district/view",
        component: () => import("@/components/edu/DistrictComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Location Settings" },
                { title: "District", active: true }
            ],
            pageTitle: "District"
        }
    },
    {
        name: "thana",
        path: "/thana/view",
        component: () => import("@/components/edu/ThanaComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Location Settings" },
                { title: "Thana", active: true }
            ],
            pageTitle: "Thana"
        }
    },
    {
        name: "academic-group-based-detail-list",
        path: "/academic/group-based-detail/list",
        component: () =>
            import("@/components/academic/AcademicGroupDetailComponent"),
        meta: {
            breadcrumb: [
                { title: "CoreSetup" },
                { title: "Academic" },
                { title: "Group Detail", active: true }
            ],

            pageTitle: "Group Detail"
        }
    },
    {
        name: "academic-year-list",
        path: "/academic/year/list",
        component: () => import("@/components/academic/AcademicYearComponent"),
        meta: {
            breadcrumb: [
                { title: "CoreSetup" },
                { title: "Academic" },
                { title: "Academic Year", active: true }
            ],

            pageTitle: "Academic Year"
        }
    },
    {
        name: "academic-fiscal-year-list",
        path: "/academic/fiscal-year/list",
        component: () => import("@/components/academic/AcademicFiscalYearComponent"),
        meta: {
            breadcrumb: [
                { title: "CoreSetup" },
                { title: "Academic" },
                { title: "Academic Fiscal Year", active: true }
            ],

            pageTitle: "Academic Fiscal Year"
        }
    },
    {
        name: "academic-designation-list",
        path: "/academic/designation/list",
        component: () =>
            import("@/components/academic/AcademicDesignationComponent"),
        meta: {
            breadcrumb: [
                { title: "CoreSetup" },
                { title: "Academic" },
                { title: "Designation", active: true }
            ],

            pageTitle: "Designation"
        }
    },
    {
        name: "academic-house-list",
        path: "/academic/house/list",
        component: () =>
            import("@/components/academic/AcademicHouseComponent"),
        meta: {
            breadcrumb: [
                { title: "CoreSetup" },
                { title: "Academic" },
                { title: "Designation", active: true }
            ],

            pageTitle: "Designation"
        }
    },
    {
        name: "edu-class-room-list",
        path: "/edu/class-room/view",
        component: () =>
            import("@/components/edu/classroom/ClassRoomListComponent"),
        meta: {
            breadcrumb: [
                { title: "Class Room" },
                { title: "Edu Class Room List", active: true }
            ],
            pageTitle: "Edu Class Room List"
        }
    },
    {
        name: "edu-class-room-new",
        path: "/edu/class-room/new",
        component: () =>
            import("@/components/edu/classroom/ClassRoomComponent"),
        meta: {
            breadcrumb: [{ title: "Edu Class Room", active: true }],
            pageTitle: "Web Setting Class Room"
        }
    },
    // sallery
    {
        name: "edu-salary-type",
        path: "/salary/type",
        component: () =>
            import("@/components/edu/payroll/salaryTypeComponent"),
        meta: {
            breadcrumb: [
                { title: "Salary Type" },
                { title: "Create Salary Type", active: true }
            ],
            pageTitle: "Create Salary Type"
        }
    },
    {
        name: "edu-salary-overtime-rules",
        path: "/salary/overtime-rules",
        component: () =>
            import("@/components/edu/payroll/salaryOverTimeRulesComponent"),
        meta: {
            breadcrumb: [
                { title: "salary overtime rules" },
                { title: "Create salary overtime rules", active: true }
            ],
            pageTitle: "Create salary overtime-rules"
        }
    },
    {
        name: "edu-salary-bonus-rules",
        path: "/salary/bonus-rules",
        component: () =>
            import("@/components/edu/payroll/salaryBonusRulesComponent"),
        meta: {
            breadcrumb: [
                { title: "salary bonus-rules" },
                { title: "Create salary bonus-rules", active: true }
            ],
            pageTitle: "Create salary bonus-rules"
        }
    },
    {
        name: "edu-salary-cut-rules",
        path: "/salary/cut-rules",
        component: () =>
            import("@/components/edu/payroll/salaryCutRulesComponent"),
        meta: {
            breadcrumb: [
                { title: "salary cut-rules" },
                { title: "Create salary cut-rules", active: true }
            ],
            pageTitle: "Create salary cut-rules"
        }
    },
    {
        name: "edu-salary-allowance-rules",
        path: "/salary/allowance-rules",
        component: () =>
            import("@/components/edu/payroll/salaryAllowanceRulesComponent"),
        meta: {
            breadcrumb: [
                { title: "salary bonus-rules" },
                { title: "Create salary allowance-rules", active: true }
            ],
            pageTitle: "Create salary allowance-rules"
        }
    },
    // / sallery end
    {
        name: "edu-class-room-edit",
        path: "/edu/class-room/edit/:classroomId",
        props: true,
        component: () =>
            import("@/components/edu/classroom/ClassRoomComponent"),
        meta: {
            breadcrumb: [
                { title: "Class Room" },
                { title: "Edu Class Room Edit", active: true }
            ],
            pageTitle: "Edu Class Room Edit"
        }
    },
    {
        name: "edu-user-component",
        path: "/permission/assign",
        component: () => import("@/components/edu/users/EduUserComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "User Setting" },
                { title: "User Role Permission", active: true }
            ],
            pageTitle: "Role Permission"
        }
    },
    {
        name: "edu-accounts-head-component",
        path: "/edu/accounts/accounts-head/view",
        component: () =>
            import("@/components/edu/accounts/accountsHeadComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Edu Accounts" },
                { title: "Accounts Head", active: true }
            ],
            pageTitle: "Accounts Head"
        }
    },
    {
        name: "edu-accounts-voucher-type-component",
        path: "/edu/accounts/accounts-voucher-type/view",
        component: () =>
            import("@/components/edu/accounts/accountsVoucherTypeComponent"),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Edu Accounts" },
                { title: "Accounts Voucher Type", active: true }
            ],
            pageTitle: "Accounts Voucher Type"
        }
    },
    {
        name: "site-replication-master-component",
        path: "/edu/replication/get-site-replication-master-form",
        component: () =>
            import(
                "@/components/edu/site/replication/SiteReplicationMasterComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Core" },
                { title: "Site Replication", active: true }
            ],
            pageTitle: "Site Replication"
        }
    },
    {
        name: "invoice-master-component",
        path: "/edu/invoice/site-invoice-master-form",
        component: () =>
            import("@/components/edu/site/transaction/InvoiceMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Invoice" },
                { title: "Site Invoice", active: true }
            ],
            pageTitle: "Site Invoice"
        }
    },
    {
        name: "non-site-master-component",
        path: "/edu/non-site/non-site-entry-form",
        component: () =>
            import("@/components/edu/non-site/NonSiteMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Institute" },
                { title: "Non Site Institute", active: true }
            ],
            pageTitle: "Non Site Institute"
        }
    },
    {
        name: "edu-site-help-setting-component",
        path: "/edu/help-desk/site-help-desk-setting-form",
        component: () =>
            import("@/components/edu/help-desk/EduSiteHelpDeskMaster"),
        meta: {
            breadcrumb: [
                { title: "Institute" },
                { title: "Non Site Institute", active: true }
            ],
            pageTitle: "Non Site Institute"
        }
    },
    {
        name: "edu-site-user-permission",
        path: "/edu/site/user-permission",
        component: () =>
            import("@/components/edu/site/user/PermissionComponent.vue"),
        meta: {
            breadcrumb: [
                { title: "Permission " },
                { title: "Permission", active: true }
            ],
            pageTitle: " User Permission"
        }
    },
    {
        name: "site-report-master-component",
        path: "/edu/report/site-report-master-form",
        component: () =>
            import("@/components/edu/site/report/SiteReportMasterComponent"),
        meta: {
            breadcrumb: [
                { title: "Report Master" },
                { title: "Report", active: true }
            ],
            pageTitle: "Report"
        }
    },
    {
        name: "edu-payment-gateway-component",
        path: "/edu/payment-gateway/view",
        component: () =>
            import(
                "@/components/edu/paymentGateway/paymentGatewayComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Payment" },
                { title: "Payment Gateway", active: true }
            ],
            pageTitle: "Payment Gateway"
        }
    },
    {
        name: "edu-payment-type-component",
        path: "/edu/payment-gateway/academic-payment-type/view",
        component: () =>
            import(
                "@/components/edu/paymentGateway/AcademicPaymentTypeComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Payment" },
                { title: "Payment Type", active: true }
            ],
            pageTitle: "Payment Type"
        }
    },
    {
        name: "edu-online-payment-method-component",
        path: "/edu/payment-gateway/academic-online-payment-method/view",
        component: () =>
            import(
                "@/components/edu/paymentGateway/AcademicOnlinePaymentMethodComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Payment" },
                { title: "Online Payment Method", active: true }
            ],
            pageTitle: "Online Payment Method"
        }
    },
    {
        name: "edu-online-payment-marchent-type-component",
        path: "/edu/payment-gateway/academic-online-payment-marchent-type/view",
        component: () =>
            import(
                "@/components/edu/paymentGateway/AcademicOnlinePaymentMarchentTypeComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Payment" },
                { title: "Online Payment Marchent Type", active: true }
            ],
            pageTitle: "Online Payment Marchent Type"
        }
    },
    {
        name: "edu-student-online-payment-recovery",
        path: "/edu/site/student-online-payment-recovery",
        component: () =>
            import(
                "@/components/edu/site/SiteOnlinePaymentRecovery"
            ),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Payment" },
                { title: "Online Payment Recovery", active: true }
            ],
            pageTitle: "Online Payment Recovery"
        }
    },
    {
        name: "edu-online-admission-payment-recovery",
        path: "/edu/site/online-admission-payment-recovery",
        component: () =>
            import(
                "@/components/edu/site/SiteOnlineAdmissionPaymentRecovery"
            ),
        meta: {
            breadcrumb: [
                { title: "Core Setup" },
                { title: "Payment" },
                { title: "Online Payment Recovery", active: true }
            ],
            pageTitle: "Online Payment Recovery"
        }
    }
];
