export default [

    {
        name: "reset-link-form",
        path: "/password/reset",
        component: () =>
            import("@/components/web-site/login/RequestResetLink.vue"),
        meta: {
            pageTitle: "Reset Link Page"
        }
    },

    {
        path: "",
        component: () => import("@/components/web-site/layouts/Main.vue"),
        children: [
            {
                name: "login-form",
                path: "login",
                component: () =>
                    import("@/components/web-site/login/LoginPage.vue"),
                meta: {
                    pageTitle: "Login"
                }
            },
            {
                path: "",
                name: "web-home",
                component: () => import("@/components/web-site/pages/Home.vue")
            },
            {
                path: "about",
                name: "web-about-us",
                component: () =>
                    import("@/components/web-site/pages/AboutUs.vue")
            },
            
            {
                path: "job-application",
                name: "job-application",
                component: () =>
                    import("@/components/web-site/pages/jobApplication.vue")
            },
            {
                path: "/web/notice/all",
                name: "web-notice-all",
                component: () =>
                    import(
                        "@/components/web-site/pages/NoticeListComponent.vue"
                    )
            },
            {
                path: "/web/classroom/all",
                name: "web-classroom-all",
                component: () =>
                    import("@/components/web-site/pages/ClassRoomComponent.vue")
            },
            {
                path: "/web/edu/classroom/all",
                name: "web-edu-classroom-all",
                component: () =>
                    import(
                        "@/components/web-site/pages/EduClassRoomComponent.vue"
                    )
            },
            {
                path: "/web/calendar",
                name: "web-calendar",
                component: () =>
                    import(
                        "@/components/web-site/pages/calendar/CalendarMasterComponent.vue"
                    )
            },
            {
                path: "/web/event/:id",
                name: "web-event-details",
                props: true,
                component: () =>
                    import("@/components/web-site/pages/EventDetails.vue")
            },
            {
                name: "site-web-student-remote-registration-form",
                path: "student-form",
                component: () =>
                    import("@/components/web-site/pages/RemoteRegistration"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Home", active: true }
                    ],
                    pageTitle: "Remote Registration"
                }
            },
            {
                name: "web-admission-form",
                path: "/web/admission-form",
                component: () =>
                    import("@/components/web-site/pages/RemoteAdmission"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Home", active: true }
                    ],
                    pageTitle: "Remote Admission"
                }
            },
            {
                name: "web-citizen-charter",
                path: "/web/citizen-charter",
                component: () =>
                    import("@/components/web-site/pages/CitizenCharter"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Home", active: true }
                    ],
                    pageTitle: "Citizen Charter"
                }
            },
            {
                name: "web-employee-details",
                path: "/web/employee-details",
                component: () =>
                    import("@/components/web-site/pages/EmployeeDetails"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Employee Details", active: true }
                    ],
                    pageTitle: "Employee Details"
                }
            },

            {
                name: "web-student-statistics",
                path: "/web/student-statistics",
                component: () =>
                     import("@/components/web-site/pages/StudentsStatistics"),
                   //  import("@/components/web-site/pages/EmployeeDetails"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Student Statistics", active: true }
                    ],
                    pageTitle: "Student Statistics"
                }
            },

            {
                name: "web-student-details",
                path: "/web/student-details",
                component: () =>
                    import("@/components/web-site/pages/StudentDetails"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Student Details", active: true }
                    ],
                    pageTitle: "Student Details"
                }
            },

            {
                name: "web-event-gallery-details",
                path: "/web/event-gallery-details",
                component: () =>
                    import("@/components/web-site/pages/EventGallery"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Event Gallery", active: true }
                    ],
                    pageTitle: "Event Gallery"
                }
            },
            {
                name: "web-contact-form",
                path: "/web/contact-form",
                component: () =>
                    import("@/components/web-site/pages/ContactForm"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Event Gallery", active: true }
                    ],
                    pageTitle: "Event Gallery"
                }
            },
            {
                name: "web-event-video-details",
                path: "/web/event-video-details",
                component: () =>
                    import("@/components/web-site/pages/EventVideo"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Event video", active: true }
                    ],
                    pageTitle: "Event video"
                }
            },
            // {
            //       path: "/student-check-exam-result/:result_id/:student_history_id/:result_type_id",
            //       name: "student-check-exam-result",
            //       component: () =>
            //       import("@/components/web-site/pages/QRCodeExamResult"),
            //   meta: {
            //       authRequired: false,
            //       breadcrumb: [
            //           { title: "Home", url: "/" },
            //           { title: "Public QR Result", active: true }
            //       ],
            //       pageTitle: "Public QR Result"
            //   }
            // },

            {
                  path: "/site-public/student-details/:username.:site_id.:student_history_id",
                  name: "student-details-for-public",
                  component: () =>
                  import("@/components/web-site/pages/PublicStudentDetails"),
              meta: {
                  authRequired: false,
                  breadcrumb: [
                      { title: "Home", url: "/" },
                      { title: "Student Details", active: true }
                  ],
                  pageTitle: "Student Details"
              }
            },
            //   {
            //     path: "/student-check-exam-combine-result/:student_history_id/:result_type_id/:version_id/:year_id/:shift_id/:class_id",
            //     name: "student-check-exam-combine-result",
            //     component: () =>
            //     import("@/components/web-site/pages/QRCodeExamCombineResult"),
            // meta: {
            //     authRequired: false,
            //     breadcrumb: [
            //         { title: "Home", url: "/" },
            //         { title: "Public QR Combile-Result", active: true }
            //     ],
            //     pageTitle: "Public QR Combile-Result"
            // }
            // },
            {
                name: "web-prospectus-details",
                path: "/web/prospectus-details",
                component: () =>
                    import("@/components/web-site/pages/ProspectusComponent"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Prospectus", active: true }
                    ],
                    pageTitle: "Prospectus"
                }
            },
            {
                name: "web-page-details",
                path: "/web/page/:evanttype",
                component: () =>
                    import("@/components/web-site/pages/ProspectusComponent"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: 'evanttype', active: true }
                    ],
                    pageTitle: 'evanttype'
                }
            },
            {
                name: "web-officer-complaint",
                path: "/web/officer-complaint",
                component: () =>
                    import("@/components/web-site/pages/OfficerComplaint"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Syllabus", active: true }
                    ],
                    pageTitle: "Syllabus"
                }
            },
            {
                name: "web-syllabus-details",
                path: "/web/syllabus-details",
                component: () =>
                    import("@/components/web-site/pages/SyllabusComponent"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Syllabus", active: true }
                    ],
                    pageTitle: "Syllabus"
                }
            },
            {
                name: "web-institute-document",
                path: "/web/institute-document",
                component: () =>
                    import("@/components/web-site/pages/InstituteDocumentComponent"),
                meta: {
                    authRequired: false,
                    breadcrumb: [
                        { title: "Home", url: "/" },
                        { title: "Syllabus", active: true }
                    ],
                    pageTitle: "Syllabus"
                }
            },
            {
                name: "shuborno-joyonti",
                path: "/web/shuborno-joyonti",
                component: () =>
                    import("@/components/web-site/pages/ShubornoJoyonti.vue")
            },
            {
                name: "exam-result",
                path: "/web/exam-result",
                component: () =>
                    import("@/components/web-site/pages/PublicExamResult.vue")
            },
            {
                name: "web-student-fee",
                path: "/web/student-fee",
                component: () =>
                    import("@/components/web-site/pages/StudentFeeCollection.vue")
            },
            {
                name: "sonali-pay-message",
                path: "/web/sonali-pay-message",
                component: () =>
                    import("@/components/web-site/pages/PaymentReceiveStatusMessageComponent.vue")
            },
            {
                name: "web-admission-fee",
                path: "/web/admission-fee",
                component: () =>
                    import("@/components/web-site/pages/AdmissionFeeCollection.vue")
            },

            {
                name: "web-admission-fee-sonali-pay-message",
                path: "/web/admission-sonali-pay-message",
                component: () =>
                    import("@/components/web-site/pages/AdmissionPaymentReceiveStatusMessageComponent.vue")
            },
            // {
            //     name: "sonali-pay-message",
            //     path: "/web/sonali-pay-message",
            //     component: () =>
            //         import("@/components/web-site/pages/PaymentReceiveStatusMessageComponent.vue")
            // },
        ]
    },

    {
        path: "/edu",
        component: () => import("@/components/web-site/layouts/edu/Main.vue"),
        children: [
            {
                path: "login",
                name: "edu-login",
                component: () =>
                    import("@/components/web-site/login/EduLoginPage.vue"),
                meta: {
                    pageTitle: "Login",
                    authRequired: false
                }
            },
            {
                path: "application",
                name: "edu-application",
                component: () =>
                    import(
                        "@/components/web-site/pages/edu/NewSiteApplication.vue"
                    ),
                meta: {
                    pageTitle: "Application",
                    authRequired: false
                }
            },
            {
                path: "feature",
                name: "edu-feature",
                component: () =>
                    import(
                        "@/components/web-site/pages/edu/EduFeaturePage.vue"
                    ),
                meta: {
                    pageTitle: "Application",
                    authRequired: false
                }
            }

        ]
    }
];
