//import Home from './Home';
//import About from './About';
//const AllNotifications = () => import('./components/logged-common/AllNotificationsComponent.vue')

import store from "@/store/store.js";

import eduRoutes from "../routes/edu_routes";
import siteRoutes from "../routes/site_routes";
import publicRoutes from "../routes/public_routes";
import studentRoutes from "../routes/student_routes";
import siteGroup from "../routes/site_group";

import Vue from "vue";
import Router from "vue-router";
Vue.use(Router);
import NProgress from "nprogress";
import "nprogress/nprogress.css";

const router = new Router({
    mode: "history",
    base: process.env.BASE_URL,
    linkExactActiveClass: "active",
    /*    scrollBehavior() {
           return { x: 0, y: 0 }
       }, */
    routes: [
        ...eduRoutes,
        ...siteRoutes,
        ...publicRoutes,
        ...studentRoutes,
        ...siteGroup,
        {
            name: "dashboard",
            path: "/dashboard",
            component: () =>
                import("@/components/dashboard/MasterComponent.vue")
        },

        {
            name: "all-notification",
            path: "/user/notification/all",
            component: () =>
                import(
                    "@/components/logged-common/AllNotificationsComponent.vue"
                )
        },

        {
            name: "the-notification",
            path: "/user/notification/view/:id",
            props: true,
            component: () =>
                import(
                    "@/components/logged-common/NotificationViewComponent.vue"
                )
        },
        {
            name: "my-invitation",
            path: "/user/my-invitation",
            component: () =>
                import(
                    "@/components/logged-common/meeting/MyInvitationComponent.vue"
                )
        },

        {
            name: "logged-common-user-profile-master",
            path: "/user/profile",
            component: () =>
                import("@/components/logged-common/MasterComponent.vue")
        },

        {
            path: "/not-found",
            name: "404-page",
            component: () => import("@/components/Error404")
        },
        {
            path: "/unauthorized",
            name: "unauthorized",
            component: () => import("@/components/logged-common/Unauthorized")
        },
        {
            path: "*",
            name: "404",
            component: () => import("@/components/Error404")
        }
    ]
});

router.beforeEach((to, from, next) => {
    //  this.$store.state.tabNumber=1;

    console.log(store.state.AppActiveUser.USER_TYPE);

    if (store.state.AppActiveUser.USER_TYPE == "eduworld") {
        // router.push({ path: '/edu-login' })
    }

    if (to.meta.authRequired) {
        //  if (!(auth.isAuthenticated() || firebaseCurrentUser)) {
        //router.push({ name: 'login'})
        // }
    }

    console.log("beforeEach:" + to.name);
    //  NProgress.start();
    NProgress.set(0.3);

    next();
});

router.beforeResolve((to, from, next) => {
    console.log("beforeResolve:" + to.name);
    if (to.name) {
        //NProgress.start()
    }
    NProgress.set(0.5);
    next();
});
router.afterEach(() => {
    // Remove initial loading
    console.log("afterEach:");
    NProgress.set(1.0);
});

export default router;

//npm install vue-lazyload
